from pathlib import Path

from .base_classes import BaseSpriteLoader


class JournalItemSheet(BaseSpriteLoader):
    _sprite_sheet_path = Path("Data/Textures/journal_entry_items.png")
    _chunk_size = 160
    _chunk_map = {
        "journal_rope": (0, 0, 1, 1),
        "journal_bomb_bag": (1, 0, 2, 1),
        "journal_bomb_box": (2, 0, 3, 1),
        "journal_paste": (3, 0, 4, 1),
        "journal_speckles": (4, 0, 5, 1),
        "journal_climbing_gloves": (5, 0, 6, 1),
        "journal_pitchers_mitt": (6, 0, 7, 1),
        "journal_spring_boots": (7, 0, 8, 1),
        "journal_spike_boots": (8, 0, 9, 1),
        "journal_compass": (9, 0, 10, 1),
        "journal_parachute": (0, 1, 1, 2),
        "journal_udjat_eye": (1, 1, 2, 2),
        "journal_kapala": (2, 1, 3, 2),
        "journal_hedjet": (3, 1, 4, 2),
        "journal_crown": (4, 1, 5, 2),
        "journal_ankh": (5, 1, 6, 2),
        "journal_royal_jelly": (6, 1, 7, 2),
        "journal_cape": (7, 1, 8, 2),
        "journal_jetpack": (8, 1, 9, 2),
        "journal_telepack": (9, 1, 10, 2),
        "journal_webgun": (0, 2, 1, 3),
        "journal_shotgun": (1, 2, 2, 3),
        "journal_freeze_ray": (2, 2, 3, 3),
        "journal_crossbow": (3, 2, 4, 3),
        "journal_camera": (4, 2, 5, 3),
        "journal_teleporter": (5, 2, 6, 3),
        "journal_mattock": (6, 2, 7, 3),
        "journal_boomerang": (7, 2, 8, 3),
        "journal_machete": (8, 2, 9, 3),
        "journal_excalibur": (9, 2, 10, 3),
        "journal_plasma_canon": (0, 3, 1, 4),
        "journal_scepter": (1, 3, 2, 4),
        "journal_idol": (2, 3, 3, 4),
        "journal_ushtabi": (3, 3, 4, 4),
        "journal_eggplant": (4, 3, 5, 4),
        "journal_cooked_turkey": (5, 3, 6, 4),
        "journal_hover_pack": (6, 3, 7, 4),
        "journal_clone_gun": (7, 3, 8, 4),
        "journal_skeleton_key": (8, 3, 9, 4),
        "journal_tablet_of_destiny": (9, 3, 10, 4),
        "journal_wooden_shield": (0, 4, 1, 5),
        "journal_metal_shield": (1, 4, 2, 5),
        "journal_clover": (2, 4, 3, 5),
        "journal_the_true_crown": (3, 4, 4, 5),
        "journal_power_pack": (4, 4, 5, 5),
        "journal_vlads_cape": (5, 4, 6, 5),
        "journal_elixir": (6, 4, 7, 5),
        "journal_tusk_idol": (7, 4, 8, 5),
        "journal_alien_compass": (8, 4, 9, 5),
        "journal_curse_pot": (9, 4, 10, 5),
        "journal_hou_yis_bow": (0, 5, 1, 6),
        "journal_arrow_of_light": (1, 5, 2, 6),
        "journal_broken_sword": (2, 5, 3, 6),
        "journal_eggplant_crown": (3, 5, 4, 6),
        "journal_blood_splat_1": (4, 5, 5, 6),
        "journal_blood_splat_2": (5, 5, 6, 6),
        "journal_blood_splat_3": (6, 5, 7, 6),
        "journal_dog_paw_print": (7, 5, 8, 6),
        "journal_cat_paw_print": (8, 5, 9, 6),
        "journal_hamster_paw_print": (9, 5, 10, 6),
        # TODO: Bottom part
    }
