"""setup.py - install script for pandoc-tablenos."""

# Copyright 2015-2020 Thomas J. Duck.
# All rights reserved.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import re
import io
import textwrap
import sys
import shutil

from setuptools import setup

# pylint: disable=invalid-name

DESCRIPTION = """\
A pandoc filter for numbering tables and their references
when converting markdown to other formats.
"""

# From https://stackoverflow.com/a/39671214
__version__ = re.search(
    r'__version__\s*=\s*[\'"]([^\'"]*)[\'"]',
    io.open('pandoc_tablenos.py', encoding='utf_8_sig').read()
    ).group(1)

setup(
    name='pandoc-tablenos',
    version=__version__,

    author='Thomas J. Duck',
    author_email='tomduck@tomduck.ca',
    description='Table number filter for pandoc',
    long_description=DESCRIPTION,
    license='GPL',
    keywords='pandoc table numbers filter',
    url='https://github.com/tomduck/pandoc-tablenos',
    download_url='https://github.com/tomduck/pandoc-tablenos/tarball/' + \
                 __version__,

    install_requires=['pandoc-xnos >= 2.4.0, < 3.0'],

    py_modules=['pandoc_tablenos'],
    entry_points={'console_scripts':['pandoc-tablenos = pandoc_tablenos:main']},

    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Intended Audience :: End Users/Desktop',
        'Environment :: Console',
        'License :: OSI Approved :: GNU General Public License v3 (GPLv3)',
        'Programming Language :: Python'
        ],
)

# Check that the pandoc-tablenos script is on the PATH
if not shutil.which('pandoc-tablenos'):
    msg = """
          ERROR: `pandoc-tablenos` script not found on PATH.  This will
          need to be corrected.  If you need help, please file an Issue at
          https://github.com/tomduck/pandoc-tablenos/issues.\n"""
    print(textwrap.dedent(msg))
    sys.exit(-1)
