# AUTOGENERATED! DO NOT EDIT! File to edit: ../00_core.ipynb.

# %% auto 0
__all__ = ['iskaggle', 'setup_comp', 'nb_meta', 'push_notebook', 'kaggle_secrets']

# %% ../00_core.ipynb 4
import os,json
from fastcore.utils import *

# %% ../00_core.ipynb 5
iskaggle = os.environ.get('KAGGLE_KERNEL_RUN_TYPE', '')

# %% ../00_core.ipynb 6
def setup_comp(competition, install=''):
    "Get a path to data for `competition`, downloading it if needed"
    if iskaggle:
        if install:
            os.system(f'pip install -Uqq {install}')
        return Path('../input')/competition
    else:
        path = Path(competition)
        if not path.exists():
            import zipfile
            api.competition_download_cli(str(competition))
            zipfile.ZipFile(f'{comp}.zip').extractall(str(competition))
        return path

# %% ../00_core.ipynb 9
def nb_meta(user, id, title, file, competition=None, private=True, gpu=False, internet=True):
    "Get the `dict` required for a kernel-metadata.json file"
    d = {
      "id": f"{user}/{id}",
      "title": title,
      "code_file": file,
      "language": "python",
      "kernel_type": "notebook",
      "is_private": private,
      "enable_gpu": gpu,
      "enable_internet": internet,
      "keywords": [],
      "dataset_sources": [],
      "kernel_sources": []
    }
    if competition: d["competition_sources"] = [f"competitions/{competition}"]
    return d

# %% ../00_core.ipynb 11
def push_notebook(user, id, title, file, path='.', competition=None, private=True, gpu=False, internet=True):
    "Push notebook `file` to Kaggle Notebooks"
    meta = nb_meta(user, id, title, file=file, competition=competition, private=private, gpu=gpu, internet=internet)
    path = Path(path)
    nm = 'kernel-metadata.json'
    path.mkdir(exist_ok=True, parents=True)
    with open(path/nm, 'w') as f: json.dump(meta, f, indent=2)
    api.kernels_push_cli(str(path))

# %% ../00_core.ipynb 13
def kaggle_secrets():
    "Use Kaggle secrets `kaggle_username` and `kaggle_key` to authenticate with the Kaggle API"
    if not iskaggle: return
    from kaggle_secrets import UserSecretsClient
    sec = UserSecretsClient()
    os.environ['KAGGLE_USERNAME'] = sec.get_secret("kaggle_username")
    if not os.environ['KAGGLE_USERNAME']: raise Exception("Please insert your Kaggle username and key into Kaggle secrets")
    os.environ['KAGGLE_KEY'] = sec.get_secret("kaggle_key")
    from kaggle import api
