from ....Functions.Winding.gen_phase_list import gen_name
from SciDataTool import Data1D, DataLinspace, DataTime
from ....Functions.check_parent import check_parent


def get_wave(self):
    """Return the wave generated by the Drive

    Parameters
    ----------
    self : DriveWave
        A DriveWave object

    Returns
    -------
    wave : DataTime
        Voltage / current waveform (Nt, qs)
    """

    wave = self.wave.get_data()

    Phase = Data1D(
        name="phase",
        unit="",
        values=gen_name(wave.shape[0], is_add_phase=True),
        is_components=True,
    )
    # Ouput.Simulation.Electrical.EEC.Drive
    if (
        check_parent(self, 4)
        and self.parent.parent.parent.parent.elec.time is not None
        and len(self.parent.parent.parent.parent.elec.time) > 1
    ):
        Time = Data1D(
            name="time", unit="s", values=self.parent.parent.parent.parent.elec.time
        )
    else:
        Nt = wave.shape[1]
        Time = DataLinspace(
            name="time",
            unit="s",
            symmetries={},
            initial=0,
            final=Nt,
            number=Nt,
            include_endpoint=False,
        )

    if self.is_current:
        return DataTime(
            name="Current", unit="A", symbol="I", axes=[Phase, Time], values=wave
        )
    else:
        return DataTime(
            name="Voltage", unit="V", symbol="U", axes=[Phase, Time], values=wave
        )
