
<div align="center">

# ☑️ FAIR Test

[![Version](https://img.shields.io/pypi/v/fair-test)](https://pypi.org/project/fair-test) [![Python versions](https://img.shields.io/pypi/pyversions/fair-test)](https://pypi.org/project/fair-test) [![MIT license](https://img.shields.io/pypi/l/fair-test)](https://github.com/MaastrichtU-IDS/fair-test/blob/main/LICENSE)

[![Publish to PyPI](https://github.com/MaastrichtU-IDS/fair-test/actions/workflows/publish.yml/badge.svg)](https://github.com/MaastrichtU-IDS/fair-test/actions/workflows/publish.yml) [![Run tests](https://github.com/MaastrichtU-IDS/fair-test/actions/workflows/test.yml/badge.svg)](https://github.com/MaastrichtU-IDS/fair-test/actions/workflows/test.yml) [![Coverage](https://sonarcloud.io/api/project_badges/measure?project=MaastrichtU-IDS_fair-test&metric=coverage)](https://sonarcloud.io/dashboard?id=MaastrichtU-IDS_fair-test)

</div>

`fair-test` is a library to build and deploy [FAIR](https://www.go-fair.org/fair-principles/) metrics tests APIs, supporting the specifications used by the [FAIR Metrics Working Group](https://github.com/FAIRMetrics/Metrics), that can be queried to assess if a resource is complying with the [FAIR principles](https://www.go-fair.org/fair-principles/) (Findable, Accessible, Interoperable, Reusable).

It aims to enable python developers to easily write, and deploy FAIR metric tests functions that can be queried by various FAIR evaluations services, such as [FAIR enough](https://fair-enough.semanticscience.org/) and the [FAIRsharing FAIR Evaluator](https://fairsharing.github.io/FAIR-Evaluator-FrontEnd/).

## 📖 Documentation

Visit the `fair-test` documentation website for more details on how to use the library to publish new FAIR tests: [**https://maastrichtu-ids.github.io/fair-test**](https://maastrichtu-ids.github.io/fair-test)

## 🧑‍💻 Contribute

If you wish to contribute to the `fair-test` library, checkout the [Contribute page](https://maastrichtu-ids.github.io/fair-test/contributing/) in the documentation to get started.
