# Generated by Django 5.2.1 on 2025-06-01 13:58

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Notification",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "type",
                    models.CharField(
                        choices=[("export_complete", "Excel Export Complete"), ("low_stock", "Low Stock Alert"), ("system", "System Notification"), ("custom", "Custom Notification")],
                        max_length=50,
                        verbose_name="Notification Type",
                    ),
                ),
                ("target_type", models.CharField(choices=[("all_staff", "All Staff"), ("specific_user", "Specific User")], default="all_staff", max_length=50, verbose_name="Target Type")),
                ("title", models.CharField(max_length=255, verbose_name="Title")),
                ("message", models.TextField(verbose_name="Message")),
                ("action_url", models.URLField(blank=True, max_length=255, null=True, verbose_name="Action URL")),
                ("file_url", models.URLField(blank=True, max_length=255, null=True, verbose_name="File URL")),
                ("is_read", models.BooleanField(default=False, verbose_name="Read Status")),
                ("created_at", models.DateTimeField(auto_now_add=True, verbose_name="Created At")),
                ("user", models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name="notifications", to=settings.AUTH_USER_MODEL, verbose_name="Target User")),
            ],
            options={
                "verbose_name": "Notification",
                "verbose_name_plural": "Notifications",
                "ordering": ["-created_at"],
                "indexes": [models.Index(fields=["user", "is_read"], name="notificatio_user_id_543da6_idx"), models.Index(fields=["target_type"], name="notificatio_target__429966_idx")],
            },
        ),
    ]
