# coding: utf8
"""Arabic unicode utils"""

import regex as re

ARABIC_ALL_CHARACTER: frozenset = frozenset("""
    \ufb50 \ufb51 \ufb52 \ufb53 \ufb54 \ufb55 \ufb56 \ufb57 \ufb58 \ufb59 \ufb5a \ufb5b
    \ufb5c \ufb5d \ufb5e \ufb5f \ufb60 \ufb61 \ufb62 \ufb63 \ufb64 \ufb65 \ufb66 \ufb67
    \ufb68 \ufb69 \ufb6a \ufb6b \ufb6c \ufb6d \ufb6e \ufb6f \ufb70 \ufb71 \ufb72 \ufb73
    \ufb74 \ufb75 \ufb76 \ufb77 \ufb78 \ufb79 \ufb7a \ufb7b \ufb7c \ufb7d \ufb7e \ufb7f
    \ufb80 \ufb81 \ufb82 \ufb83 \ufb84 \ufb85 \ufb86 \ufb87 \ufb88 \ufb89 \ufb8a \ufb8b
    \ufb8c \ufb8d \ufb8e \ufb8f \ufb90 \ufb91 \ufb92 \ufb93 \ufb94 \ufb95 \ufb96 \ufb97
    \ufb98 \ufb99 \ufb9a \ufb9b \ufb9c \ufb9d \ufb9e \ufb9f \ufba0 \ufba1 \ufba2 \ufba3
    \ufba4 \ufba5 \ufba6 \ufba7 \ufba8 \ufba9 \ufbaa \ufbab \ufbac \ufbad \ufbae \ufbaf
    \ufbb0 \ufbb1 \ufbb2 \ufbb3 \ufbb4 \ufbb5 \ufbb6 \ufbb7 \ufbb8 \ufbb9 \ufbba \ufbbb
    \ufbbc \ufbbd \ufbbe \ufbbf \ufbc0 \ufbc1 \ufbc2 \ufbc3 \ufbc4 \ufbc5 \ufbc6 \ufbc7
    \ufbc8 \ufbc9 \ufbca \ufbcb \ufbcc \ufbcd \ufbce \ufbcf \ufbd0 \ufbd1 \ufbd2 \ufbd3
    \ufbd4 \ufbd5 \ufbd6 \ufbd7 \ufbd8 \ufbd9 \ufbda \ufbdb \ufbdc \ufbdd \ufbde \ufbdf
    \ufbe0 \ufbe1 \ufbe2 \ufbe3 \ufbe4 \ufbe5 \ufbe6 \ufbe7 \ufbe8 \ufbe9 \ufbea \ufbeb
    \ufbec \ufbed \ufbee \ufbef \ufbf0 \ufbf1 \ufbf2 \ufbf3 \ufbf4 \ufbf5 \ufbf6 \ufbf7
    \ufbf8 \ufbf9 \ufbfa \ufbfb \ufbfc \ufbfd \ufbfe \ufbff \ufc00 \ufc01 \ufc02 \ufc03
    \ufc04 \ufc05 \ufc06 \ufc07 \ufc08 \ufc09 \ufc0a \ufc0b \ufc0c \ufc0d \ufc0e \ufc0f
    \ufc10 \ufc11 \ufc12 \ufc13 \ufc14 \ufc15 \ufc16 \ufc17 \ufc18 \ufc19 \ufc1a \ufc1b
    \ufc1c \ufc1d \ufc1e \ufc1f \ufc20 \ufc21 \ufc22 \ufc23 \ufc24 \ufc25 \ufc26 \ufc27
    \ufc28 \ufc29 \ufc2a \ufc2b \ufc2c \ufc2d \ufc2e \ufc2f \ufc30 \ufc31 \ufc32 \ufc33
    \ufc34 \ufc35 \ufc36 \ufc37 \ufc38 \ufc39 \ufc3a \ufc3b \ufc3c \ufc3d \ufc3e \ufc3f
    \ufc40 \ufc41 \ufc42 \ufc43 \ufc44 \ufc45 \ufc46 \ufc47 \ufc48 \ufc49 \ufc4a \ufc4b
    \ufc4c \ufc4d \ufc4e \ufc4f \ufc50 \ufc51 \ufc52 \ufc53 \ufc54 \ufc55 \ufc56 \ufc57
    \ufc58 \ufc59 \ufc5a \ufc5b \ufc5c \ufc5d \ufc5e \ufc5f \ufc60 \ufc61 \ufc62 \ufc63
    \ufc64 \ufc65 \ufc66 \ufc67 \ufc68 \ufc69 \ufc6a \ufc6b \ufc6c \ufc6d \ufc6e \ufc6f
    \ufc70 \ufc71 \ufc72 \ufc73 \ufc74 \ufc75 \ufc76 \ufc77 \ufc78 \ufc79 \ufc7a \ufc7b
    \ufc7c \ufc7d \ufc7e \ufc7f \ufc80 \ufc81 \ufc82 \ufc83 \ufc84 \ufc85 \ufc86 \ufc87
    \ufc88 \ufc89 \ufc8a \ufc8b \ufc8c \ufc8d \ufc8e \ufc8f \ufc90 \ufc91 \ufc92 \ufc93
    \ufc94 \ufc95 \ufc96 \ufc97 \ufc98 \ufc99 \ufc9a \ufc9b \ufc9c \ufc9d \ufc9e \ufc9f
    \ufca0 \ufca1 \ufca2 \ufca3 \ufca4 \ufca5 \ufca6 \ufca7 \ufca8 \ufca9 \ufcaa \ufcab
    \ufcac \ufcad \ufcae \ufcaf \ufcb0 \ufcb1 \ufcb2 \ufcb3 \ufcb4 \ufcb5 \ufcb6 \ufcb7
    \ufcb8 \ufcb9 \ufcba \ufcbb \ufcbc \ufcbd \ufcbe \ufcbf \ufcc0 \ufcc1 \ufcc2 \ufcc3
    \ufcc4 \ufcc5 \ufcc6 \ufcc7 \ufcc8 \ufcc9 \ufcca \ufccb \ufccc \ufccd \ufcce \ufccf
    \ufcd0 \ufcd1 \ufcd2 \ufcd3 \ufcd4 \ufcd5 \ufcd6 \ufcd7 \ufcd8 \ufcd9 \ufcda \ufcdb
    \ufcdc \ufcdd \ufcde \ufcdf \ufce0 \ufce1 \ufce2 \ufce3 \ufce4 \ufce5 \ufce6 \ufce7
    \ufce8 \ufce9 \ufcea \ufceb \ufcec \ufced \ufcee \ufcef \ufcf0 \ufcf1 \ufcf2 \ufcf3
    \ufcf4 \ufcf5 \ufcf6 \ufcf7 \ufcf8 \ufcf9 \ufcfa \ufcfb \ufcfc \ufcfd \ufcfe \ufcff
    \ufd00 \ufd01 \ufd02 \ufd03 \ufd04 \ufd05 \ufd06 \ufd07 \ufd08 \ufd09 \ufd0a \ufd0b
    \ufd0c \ufd0d \ufd0e \ufd0f \ufd10 \ufd11 \ufd12 \ufd13 \ufd14 \ufd15 \ufd16 \ufd17
    \ufd18 \ufd19 \ufd1a \ufd1b \ufd1c \ufd1d \ufd1e \ufd1f \ufd20 \ufd21 \ufd22 \ufd23
    \ufd24 \ufd25 \ufd26 \ufd27 \ufd28 \ufd29 \ufd2a \ufd2b \ufd2c \ufd2d \ufd2e \ufd2f
    \ufd30 \ufd31 \ufd32 \ufd33 \ufd34 \ufd35 \ufd36 \ufd37 \ufd38 \ufd39 \ufd3a \ufd3b
    \ufd3c \ufd3d \ufd3e \ufd3f \ufd40 \ufd41 \ufd42 \ufd43 \ufd44 \ufd45 \ufd46 \ufd47
    \ufd48 \ufd49 \ufd4a \ufd4b \ufd4c \ufd4d \ufd4e \ufd4f \ufd50 \ufd51 \ufd52 \ufd53
    \ufd54 \ufd55 \ufd56 \ufd57 \ufd58 \ufd59 \ufd5a \ufd5b \ufd5c \ufd5d \ufd5e \ufd5f
    \ufd60 \ufd61 \ufd62 \ufd63 \ufd64 \ufd65 \ufd66 \ufd67 \ufd68 \ufd69 \ufd6a \ufd6b
    \ufd6c \ufd6d \ufd6e \ufd6f \ufd70 \ufd71 \ufd72 \ufd73 \ufd74 \ufd75 \ufd76 \ufd77
    \ufd78 \ufd79 \ufd7a \ufd7b \ufd7c \ufd7d \ufd7e \ufd7f \ufd80 \ufd81 \ufd82 \ufd83
    \ufd84 \ufd85 \ufd86 \ufd87 \ufd88 \ufd89 \ufd8a \ufd8b \ufd8c \ufd8d \ufd8e \ufd8f
    \ufd90 \ufd91 \ufd92 \ufd93 \ufd94 \ufd95 \ufd96 \ufd97 \ufd98 \ufd99 \ufd9a \ufd9b
    \ufd9c \ufd9d \ufd9e \ufd9f \ufda0 \ufda1 \ufda2 \ufda3 \ufda4 \ufda5 \ufda6 \ufda7
    \ufda8 \ufda9 \ufdaa \ufdab \ufdac \ufdad \ufdae \ufdaf \ufdb0 \ufdb1 \ufdb2 \ufdb3
    \ufdb4 \ufdb5 \ufdb6 \ufdb7 \ufdb8 \ufdb9 \ufdba \ufdbb \ufdbc \ufdbd \ufdbe \ufdbf
    \ufdc0 \ufdc1 \ufdc2 \ufdc3 \ufdc4 \ufdc5 \ufdc6 \ufdc7 \ufdc8 \ufdc9 \ufdca \ufdcb
    \ufdcc \ufdcd \ufdce \ufdcf \ufdd0 \ufdd1 \ufdd2 \ufdd3 \ufdd4 \ufdd5 \ufdd6 \ufdd7
    \ufdd8 \ufdd9 \ufdda \ufddb \ufddc \ufddd \ufdde \ufddf \ufde0 \ufde1 \ufde2 \ufde3
    \ufde4 \ufde5 \ufde6 \ufde7 \ufde8 \ufde9 \ufdea \ufdeb \ufdec \ufded \ufdee \ufdef
    \ufdf0 \ufdf1 \ufdf2 \ufdf3 \ufdf4 \ufdf5 \ufdf6 \ufdf7 \ufdf8 \ufdf9 \ufdfa \ufdfb \ufdfc
    \ufe70 \ufe71 \ufe72 \ufe73 \ufe74 \ufe75 \ufe76 \ufe77 \ufe78 \ufe79 \ufe7a \ufe7b
    \ufe7c \ufe7d \ufe7e \ufe7f \ufe80 \ufe81 \ufe82 \ufe83 \ufe84 \ufe85 \ufe86 \ufe87
    \ufe88 \ufe89 \ufe8a \ufe8b \ufe8c \ufe8d \ufe8e \ufe8f \ufe90 \ufe91 \ufe92 \ufe93
    \ufe94 \ufe95 \ufe96 \ufe97 \ufe98 \ufe99 \ufe9a \ufe9b \ufe9c \ufe9d \ufe9e \ufe9f
    \ufea0 \ufea1 \ufea2 \ufea3 \ufea4 \ufea5 \ufea6 \ufea7 \ufea8 \ufea9 \ufeaa \ufeab
    \ufeac \ufead \ufeae \ufeaf \ufeb0 \ufeb1 \ufeb2 \ufeb3 \ufeb4 \ufeb5 \ufeb6 \ufeb7
    \ufeb8 \ufeb9 \ufeba \ufebb \ufebc \ufebd \ufebe \ufebf \ufec0 \ufec1 \ufec2 \ufec3
    \ufec4 \ufec5 \ufec6 \ufec7 \ufec8 \ufec9 \ufeca \ufecb \ufecc \ufecd \ufece \ufecf
    \ufed0 \ufed1 \ufed2 \ufed3 \ufed4 \ufed5 \ufed6 \ufed7 \ufed8 \ufed9 \ufeda \ufedb
    \ufedc \ufedd \ufede \ufedf \ufee0 \ufee1 \ufee2 \ufee3 \ufee4 \ufee5 \ufee6 \ufee7
    \ufee8 \ufee9 \ufeea \ufeeb \ufeec \ufeed \ufeee \ufeef \ufef0 \ufef1 \ufef2 \ufef3
    \ufef4 \ufef5 \ufef6 \ufef7 \ufef8 \ufef9 \ufefa \ufefb \ufefc \ufefd \ufefe

""".split())

FB50_FEFF_RANGE_RE = re.compile(f'[{"".join(ARABIC_ALL_CHARACTER)}]+', flags=re.U | re.M | re.I)


def find_arabic_words(text: str) -> str:
    """
    Find all arabic words
    Args:
        text (str): text
    Returns:
        str
    """
    return FB50_FEFF_RANGE_RE.findall(text)
