# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_str

class MsgRconCmd(PrettyPrint):
    def __init__(
            self,
            cmd: str = 'default'
    ) -> None:
        self.message_name = 'rcon_cmd'
        self.system_message = True
        self.header: ChunkHeader

        self.cmd: str = cmd

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.cmd = unpacker.get_str()
        return True

    def pack(self) -> bytes:
        return pack_str(self.cmd)