# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int

class MsgSvWeaponPickup(PrettyPrint):
    def __init__(
            self,
            weapon: int = 0
    ) -> None:
        self.message_name = 'sv_weapon_pickup'
        self.system_message = False
        self.header: ChunkHeader

        self.weapon: int = weapon

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.weapon = unpacker.get_int() # TODO: this is a enum
        return True

    def pack(self) -> bytes:
        return pack_int(self.weapon)