# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int

class MsgSvKillMsg(PrettyPrint):
    def __init__(
            self,
            killer: int = 0,
            victim: int = 0,
            weapon: int = 0,
            mode_special: int = 0
    ) -> None:
        self.message_name = 'sv_kill_msg'
        self.system_message = False
        self.header: ChunkHeader

        self.killer: int = killer
        self.victim: int = victim
        self.weapon: int = weapon
        self.mode_special: int = mode_special

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.killer = unpacker.get_int()
        self.victim = unpacker.get_int()
        self.weapon = unpacker.get_int()
        self.mode_special = unpacker.get_int()
        return True

    def pack(self) -> bytes:
        return pack_int(self.killer) + \
            pack_int(self.victim) + \
            pack_int(self.weapon) + \
            pack_int(self.mode_special)