# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int, pack_str

class MsgSvClientInfo(PrettyPrint):
    def __init__(
            self,
            client_id: int = 0,
            local: bool = False,
            team: int = 0,
            name: str = 'default',
            clan: str = 'default',
            country: int = 0,
            skin_part_names: int = 0,
            use_custom_colors: int = 0,
            skin_part_colors: int = 0,
            silent: bool = False
    ) -> None:
        self.message_name = 'sv_client_info'
        self.system_message = False
        self.header: ChunkHeader

        self.client_id: int = client_id
        self.local: bool = local
        self.team: int = team
        self.name: str = name
        self.clan: str = clan
        self.country: int = country
        self.skin_part_names: int = skin_part_names
        self.use_custom_colors: int = use_custom_colors
        self.skin_part_colors: int = skin_part_colors
        self.silent: bool = silent

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.client_id = unpacker.get_int()
        self.local = unpacker.get_int() == 1
        self.team = unpacker.get_int() # TODO: this is a enum
        self.name = unpacker.get_str()
        self.clan = unpacker.get_str()
        self.country = unpacker.get_int()
        self.skin_part_names = unpacker.get_int() # TODO: this is an array
        self.use_custom_colors = unpacker.get_int() # TODO: this is an array
        self.skin_part_colors = unpacker.get_int() # TODO: this is an array
        self.silent = unpacker.get_int() == 1
        return True

    def pack(self) -> bytes:
        return pack_int(self.client_id) + \
            pack_int(self.local) + \
            pack_int(self.team) + \
            pack_str(self.name) + \
            pack_str(self.clan) + \
            pack_int(self.country) + \
            pack_int(self.skin_part_names) + \
            pack_int(self.use_custom_colors) + \
            pack_int(self.skin_part_colors) + \
            pack_int(self.silent)