# generated by scripts/generate_messages.py

from twnet_parser.pretty_print import PrettyPrint
from twnet_parser.packer import Unpacker
from twnet_parser.chunk_header import ChunkHeader
from twnet_parser.packer import pack_int, pack_str

class MsgDeClientLeave(PrettyPrint):
    def __init__(
            self,
            name: str = 'default',
            client_id: int = 0,
            reason: str = 'default'
    ) -> None:
        self.message_name = 'de_client_leave'
        self.system_message = False
        self.header: ChunkHeader

        self.name: str = name
        self.client_id: int = client_id
        self.reason: str = reason

    # first byte of data
    # has to be the first byte of the message payload
    # NOT the chunk header and NOT the message id
    def unpack(self, data: bytes) -> bool:
        unpacker = Unpacker(data)
        self.name = unpacker.get_str()
        self.client_id = unpacker.get_int()
        self.reason = unpacker.get_str()
        return True

    def pack(self) -> bytes:
        return pack_str(self.name) + \
            pack_int(self.client_id) + \
            pack_str(self.reason)