"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirehosePutRecordAction = exports.FirehoseRecordSeparator = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_1 = require("./private/role");
/**
 * (experimental) Record Separator to be used to separate records.
 *
 * @experimental
 */
var FirehoseRecordSeparator;
(function (FirehoseRecordSeparator) {
    FirehoseRecordSeparator["NEWLINE"] = "\n";
    FirehoseRecordSeparator["TAB"] = "\t";
    FirehoseRecordSeparator["WINDOWS_NEWLINE"] = "\r\n";
    FirehoseRecordSeparator["COMMA"] = ",";
})(FirehoseRecordSeparator = exports.FirehoseRecordSeparator || (exports.FirehoseRecordSeparator = {}));
/**
 * (experimental) The action to put the record from an MQTT message to the Kinesis Data Firehose stream.
 *
 * @experimental
 */
class FirehosePutRecordAction {
    /**
     * @param stream The Kinesis Data Firehose stream to which to put records.
     * @param props Optional properties to not use default.
     * @experimental
     */
    constructor(stream, props = {}) {
        this.stream = stream;
        jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_FirehosePutRecordActionProps(props);
        this.batchMode = props.batchMode;
        this.recordSeparator = props.recordSeparator;
        this.role = props.role;
    }
    /**
     * (experimental) (experimental) Returns the topic rule action specification.
     *
     * @experimental
     */
    bind(rule) {
        var _b;
        const role = (_b = this.role) !== null && _b !== void 0 ? _b : role_1.singletonActionRole(rule);
        this.stream.grantPutRecords(role);
        return {
            configuration: {
                firehose: {
                    batchMode: this.batchMode,
                    deliveryStreamName: this.stream.deliveryStreamName,
                    roleArn: role.roleArn,
                    separator: this.recordSeparator,
                },
            },
        };
    }
}
exports.FirehosePutRecordAction = FirehosePutRecordAction;
_a = JSII_RTTI_SYMBOL_1;
FirehosePutRecordAction[_a] = { fqn: "@aws-cdk/aws-iot-actions.FirehosePutRecordAction", version: "1.141.0" };
//# sourceMappingURL=data:application/json;base64,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