# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/07_utils.ipynb.

# %% auto 0
__all__ = ['load_yaml', 'RLHFConfig', 'create_reference_model']

# %% ../nbs/07_utils.ipynb 3
import yaml
from copy import deepcopy
from dataclasses import dataclass

# %% ../nbs/07_utils.ipynb 4
def load_yaml(config_path):
    with open(config_path, "r") as f:
        return yaml.safe_load(f)

# %% ../nbs/07_utils.ipynb 5
@dataclass
class RLHFConfig:
    # PPO config
    epsilon: float = 0.1
    # entropy coefficient
    ent_coef: float = 0.01
    vf_coef: float = 0.1

# %% ../nbs/07_utils.ipynb 7
def create_reference_model(model):
    ref_model = deepcopy(model).eval()
    return ref_model
