# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.  # noqa: E501

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from docusign_esign.client.configuration import Configuration


class Brand(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'brand_company': 'str',
        'brand_id': 'str',
        'brand_languages': 'list[str]',
        'brand_name': 'str',
        'colors': 'list[NameValue]',
        'default_brand_language': 'str',
        'email_content': 'list[BrandEmailContent]',
        'error_details': 'ErrorDetails',
        'is_overriding_company_name': 'bool',
        'is_sending_default': 'bool',
        'is_signing_default': 'bool',
        'landing_pages': 'list[NameValue]',
        'links': 'list[BrandLink]',
        'logos': 'BrandLogos',
        'resources': 'BrandResourceUrls'
    }

    attribute_map = {
        'brand_company': 'brandCompany',
        'brand_id': 'brandId',
        'brand_languages': 'brandLanguages',
        'brand_name': 'brandName',
        'colors': 'colors',
        'default_brand_language': 'defaultBrandLanguage',
        'email_content': 'emailContent',
        'error_details': 'errorDetails',
        'is_overriding_company_name': 'isOverridingCompanyName',
        'is_sending_default': 'isSendingDefault',
        'is_signing_default': 'isSigningDefault',
        'landing_pages': 'landingPages',
        'links': 'links',
        'logos': 'logos',
        'resources': 'resources'
    }

    def __init__(self, _configuration=None, **kwargs):  # noqa: E501
        """Brand - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._brand_company = None
        self._brand_id = None
        self._brand_languages = None
        self._brand_name = None
        self._colors = None
        self._default_brand_language = None
        self._email_content = None
        self._error_details = None
        self._is_overriding_company_name = None
        self._is_sending_default = None
        self._is_signing_default = None
        self._landing_pages = None
        self._links = None
        self._logos = None
        self._resources = None
        self.discriminator = None

        setattr(self, "_{}".format('brand_company'), kwargs.get('brand_company', None))
        setattr(self, "_{}".format('brand_id'), kwargs.get('brand_id', None))
        setattr(self, "_{}".format('brand_languages'), kwargs.get('brand_languages', None))
        setattr(self, "_{}".format('brand_name'), kwargs.get('brand_name', None))
        setattr(self, "_{}".format('colors'), kwargs.get('colors', None))
        setattr(self, "_{}".format('default_brand_language'), kwargs.get('default_brand_language', None))
        setattr(self, "_{}".format('email_content'), kwargs.get('email_content', None))
        setattr(self, "_{}".format('error_details'), kwargs.get('error_details', None))
        setattr(self, "_{}".format('is_overriding_company_name'), kwargs.get('is_overriding_company_name', None))
        setattr(self, "_{}".format('is_sending_default'), kwargs.get('is_sending_default', None))
        setattr(self, "_{}".format('is_signing_default'), kwargs.get('is_signing_default', None))
        setattr(self, "_{}".format('landing_pages'), kwargs.get('landing_pages', None))
        setattr(self, "_{}".format('links'), kwargs.get('links', None))
        setattr(self, "_{}".format('logos'), kwargs.get('logos', None))
        setattr(self, "_{}".format('resources'), kwargs.get('resources', None))

    @property
    def brand_company(self):
        """Gets the brand_company of this Brand.  # noqa: E501

        The name of the company associated with this brand.  # noqa: E501

        :return: The brand_company of this Brand.  # noqa: E501
        :rtype: str
        """
        return self._brand_company

    @brand_company.setter
    def brand_company(self, brand_company):
        """Sets the brand_company of this Brand.

        The name of the company associated with this brand.  # noqa: E501

        :param brand_company: The brand_company of this Brand.  # noqa: E501
        :type: str
        """

        self._brand_company = brand_company

    @property
    def brand_id(self):
        """Gets the brand_id of this Brand.  # noqa: E501

        The ID used to identify a specific brand in API calls.  # noqa: E501

        :return: The brand_id of this Brand.  # noqa: E501
        :rtype: str
        """
        return self._brand_id

    @brand_id.setter
    def brand_id(self, brand_id):
        """Sets the brand_id of this Brand.

        The ID used to identify a specific brand in API calls.  # noqa: E501

        :param brand_id: The brand_id of this Brand.  # noqa: E501
        :type: str
        """

        self._brand_id = brand_id

    @property
    def brand_languages(self):
        """Gets the brand_languages of this Brand.  # noqa: E501

          # noqa: E501

        :return: The brand_languages of this Brand.  # noqa: E501
        :rtype: list[str]
        """
        return self._brand_languages

    @brand_languages.setter
    def brand_languages(self, brand_languages):
        """Sets the brand_languages of this Brand.

          # noqa: E501

        :param brand_languages: The brand_languages of this Brand.  # noqa: E501
        :type: list[str]
        """

        self._brand_languages = brand_languages

    @property
    def brand_name(self):
        """Gets the brand_name of this Brand.  # noqa: E501

        The name of the brand.  # noqa: E501

        :return: The brand_name of this Brand.  # noqa: E501
        :rtype: str
        """
        return self._brand_name

    @brand_name.setter
    def brand_name(self, brand_name):
        """Sets the brand_name of this Brand.

        The name of the brand.  # noqa: E501

        :param brand_name: The brand_name of this Brand.  # noqa: E501
        :type: str
        """

        self._brand_name = brand_name

    @property
    def colors(self):
        """Gets the colors of this Brand.  # noqa: E501

          # noqa: E501

        :return: The colors of this Brand.  # noqa: E501
        :rtype: list[NameValue]
        """
        return self._colors

    @colors.setter
    def colors(self, colors):
        """Sets the colors of this Brand.

          # noqa: E501

        :param colors: The colors of this Brand.  # noqa: E501
        :type: list[NameValue]
        """

        self._colors = colors

    @property
    def default_brand_language(self):
        """Gets the default_brand_language of this Brand.  # noqa: E501

          # noqa: E501

        :return: The default_brand_language of this Brand.  # noqa: E501
        :rtype: str
        """
        return self._default_brand_language

    @default_brand_language.setter
    def default_brand_language(self, default_brand_language):
        """Sets the default_brand_language of this Brand.

          # noqa: E501

        :param default_brand_language: The default_brand_language of this Brand.  # noqa: E501
        :type: str
        """

        self._default_brand_language = default_brand_language

    @property
    def email_content(self):
        """Gets the email_content of this Brand.  # noqa: E501

          # noqa: E501

        :return: The email_content of this Brand.  # noqa: E501
        :rtype: list[BrandEmailContent]
        """
        return self._email_content

    @email_content.setter
    def email_content(self, email_content):
        """Sets the email_content of this Brand.

          # noqa: E501

        :param email_content: The email_content of this Brand.  # noqa: E501
        :type: list[BrandEmailContent]
        """

        self._email_content = email_content

    @property
    def error_details(self):
        """Gets the error_details of this Brand.  # noqa: E501


        :return: The error_details of this Brand.  # noqa: E501
        :rtype: ErrorDetails
        """
        return self._error_details

    @error_details.setter
    def error_details(self, error_details):
        """Sets the error_details of this Brand.


        :param error_details: The error_details of this Brand.  # noqa: E501
        :type: ErrorDetails
        """

        self._error_details = error_details

    @property
    def is_overriding_company_name(self):
        """Gets the is_overriding_company_name of this Brand.  # noqa: E501

          # noqa: E501

        :return: The is_overriding_company_name of this Brand.  # noqa: E501
        :rtype: bool
        """
        return self._is_overriding_company_name

    @is_overriding_company_name.setter
    def is_overriding_company_name(self, is_overriding_company_name):
        """Sets the is_overriding_company_name of this Brand.

          # noqa: E501

        :param is_overriding_company_name: The is_overriding_company_name of this Brand.  # noqa: E501
        :type: bool
        """

        self._is_overriding_company_name = is_overriding_company_name

    @property
    def is_sending_default(self):
        """Gets the is_sending_default of this Brand.  # noqa: E501

          # noqa: E501

        :return: The is_sending_default of this Brand.  # noqa: E501
        :rtype: bool
        """
        return self._is_sending_default

    @is_sending_default.setter
    def is_sending_default(self, is_sending_default):
        """Sets the is_sending_default of this Brand.

          # noqa: E501

        :param is_sending_default: The is_sending_default of this Brand.  # noqa: E501
        :type: bool
        """

        self._is_sending_default = is_sending_default

    @property
    def is_signing_default(self):
        """Gets the is_signing_default of this Brand.  # noqa: E501

          # noqa: E501

        :return: The is_signing_default of this Brand.  # noqa: E501
        :rtype: bool
        """
        return self._is_signing_default

    @is_signing_default.setter
    def is_signing_default(self, is_signing_default):
        """Sets the is_signing_default of this Brand.

          # noqa: E501

        :param is_signing_default: The is_signing_default of this Brand.  # noqa: E501
        :type: bool
        """

        self._is_signing_default = is_signing_default

    @property
    def landing_pages(self):
        """Gets the landing_pages of this Brand.  # noqa: E501

          # noqa: E501

        :return: The landing_pages of this Brand.  # noqa: E501
        :rtype: list[NameValue]
        """
        return self._landing_pages

    @landing_pages.setter
    def landing_pages(self, landing_pages):
        """Sets the landing_pages of this Brand.

          # noqa: E501

        :param landing_pages: The landing_pages of this Brand.  # noqa: E501
        :type: list[NameValue]
        """

        self._landing_pages = landing_pages

    @property
    def links(self):
        """Gets the links of this Brand.  # noqa: E501

          # noqa: E501

        :return: The links of this Brand.  # noqa: E501
        :rtype: list[BrandLink]
        """
        return self._links

    @links.setter
    def links(self, links):
        """Sets the links of this Brand.

          # noqa: E501

        :param links: The links of this Brand.  # noqa: E501
        :type: list[BrandLink]
        """

        self._links = links

    @property
    def logos(self):
        """Gets the logos of this Brand.  # noqa: E501


        :return: The logos of this Brand.  # noqa: E501
        :rtype: BrandLogos
        """
        return self._logos

    @logos.setter
    def logos(self, logos):
        """Sets the logos of this Brand.


        :param logos: The logos of this Brand.  # noqa: E501
        :type: BrandLogos
        """

        self._logos = logos

    @property
    def resources(self):
        """Gets the resources of this Brand.  # noqa: E501


        :return: The resources of this Brand.  # noqa: E501
        :rtype: BrandResourceUrls
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """Sets the resources of this Brand.


        :param resources: The resources of this Brand.  # noqa: E501
        :type: BrandResourceUrls
        """

        self._resources = resources

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Brand, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Brand):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Brand):
            return True

        return self.to_dict() != other.to_dict()
