"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.countResources = exports.hasResourceProperties = exports.hasResource = exports.findResources = void 0;
const __1 = require("..");
const absent_1 = require("./matchers/absent");
const section_1 = require("./section");
function findResources(template, type, props = {}) {
    const section = template.Resources ?? {};
    const result = section_1.matchSection(filterType(section, type), props);
    if (!result.match) {
        return {};
    }
    return result.matches;
}
exports.findResources = findResources;
function hasResource(template, type, props) {
    const section = template.Resources ?? {};
    const result = section_1.matchSection(filterType(section, type), props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return `No resource with type ${type} found`;
    }
    return [
        `Template has ${result.analyzedCount} resources with type ${type}, but none match as expected.`,
        section_1.formatFailure(result.closestResult),
    ].join('\n');
}
exports.hasResource = hasResource;
function hasResourceProperties(template, type, props) {
    // amended needs to be a deep copy to avoid modifying the template.
    let amended = JSON.parse(JSON.stringify(template));
    // special case to exclude AbsentMatch because adding an empty Properties object will affect its evaluation.
    if (!__1.Matcher.isMatcher(props) || !(props instanceof absent_1.AbsentMatch)) {
        amended = addEmptyProperties(amended);
    }
    return hasResource(amended, type, __1.Match.objectLike({
        Properties: props,
    }));
}
exports.hasResourceProperties = hasResourceProperties;
function countResources(template, type) {
    const section = template.Resources ?? {};
    const types = filterType(section, type);
    return Object.entries(types).length;
}
exports.countResources = countResources;
function addEmptyProperties(template) {
    let section = template.Resources ?? {};
    Object.keys(section).map((key) => {
        if (!section[key].hasOwnProperty('Properties')) {
            section[key].Properties = {};
        }
    });
    return template;
}
function filterType(section, type) {
    return Object.entries(section ?? {})
        .filter(([_, v]) => v.Type === type)
        .reduce((agg, [k, v]) => { return { ...agg, [k]: v }; }, {});
}
//# sourceMappingURL=data:application/json;base64,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