"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasMapping = exports.findMappings = void 0;
const section_1 = require("./section");
function findMappings(template, logicalId, props = {}) {
    const section = template.Mappings ?? {};
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (!result.match) {
        return {};
    }
    return result.matches;
}
exports.findMappings = findMappings;
function hasMapping(template, logicalId, props) {
    const section = template.Mappings ?? {};
    const result = section_1.matchSection(section_1.filterLogicalId(section, logicalId), props);
    if (result.match) {
        return;
    }
    if (result.closestResult === undefined) {
        return 'No mappings found in the template';
    }
    return [
        `Template has ${result.analyzedCount} mappings, but none match as expected.`,
        section_1.formatFailure(result.closestResult),
    ].join('\n');
}
exports.hasMapping = hasMapping;
//# sourceMappingURL=data:application/json;base64,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