"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExecuteScriptSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const execute_script_step_1 = require("../../parent-steps/automation/execute-script-step");
const python_script_handler_1 = require("../../script/python-script-handler");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implementation for aws:executeScript
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-executeScript.html
 */
class ExecuteScriptSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step) {
        super(step);
        this.action = 'aws:executeScript';
        this.executeScriptStep = step;
    }
    /**
     * Runs the simulation. Nests returned object into a "Payload" key to mimic SSM behavior.
     * Switch by language and execute code based on specified language.
     */
    executeStep(inputs) {
        switch (this.executeScriptStep.language) {
            case execute_script_step_1.ScriptLanguage.PYTHON:
                const pyHandler = new python_script_handler_1.PythonScriptHandler();
                return pyHandler.run(this.executeScriptStep.fullPathToCode, this.executeScriptStep.handlerName, inputs);
            default:
                throw new Error(`Language ${this.executeScriptStep.language} not supported.`);
        }
    }
}
exports.ExecuteScriptSimulation = ExecuteScriptSimulation;
_a = JSII_RTTI_SYMBOL_1;
ExecuteScriptSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.ExecuteScriptSimulation", version: "0.0.13" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhlY3V0ZS1zY3JpcHQtc2ltdWxhdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9zaW11bGF0aW9uL2F1dG9tYXRpb24vZXhlY3V0ZS1zY3JpcHQtc2ltdWxhdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDJGQUFzRztBQUN0Ryw4RUFBeUU7QUFDekUsNkVBQXdFO0FBRXhFOzs7R0FHRztBQUNILE1BQWEsdUJBQXdCLFNBQVEscURBQXdCO0lBSW5FLFlBQVksSUFBdUI7UUFDakMsS0FBSyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBSEwsV0FBTSxHQUFXLG1CQUFtQixDQUFDO1FBSTVDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUM7SUFDaEMsQ0FBQztJQUVEOzs7T0FHRztJQUNJLFdBQVcsQ0FBQyxNQUErQjtRQUNoRCxRQUFRLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUU7WUFDdkMsS0FBSyxvQ0FBYyxDQUFDLE1BQU07Z0JBQ3hCLE1BQU0sU0FBUyxHQUFHLElBQUksMkNBQW1CLEVBQUUsQ0FBQztnQkFDNUMsT0FBTyxTQUFTLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxNQUFNLENBQUMsQ0FBQztZQUMxRztnQkFDRSxNQUFNLElBQUksS0FBSyxDQUFDLFlBQVksSUFBSSxDQUFDLGlCQUFpQixDQUFDLFFBQVEsaUJBQWlCLENBQUMsQ0FBQztTQUNqRjtJQUNILENBQUM7O0FBckJILDBEQXVCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEV4ZWN1dGVTY3JpcHRTdGVwLCBTY3JpcHRMYW5ndWFnZSB9IGZyb20gJy4uLy4uL3BhcmVudC1zdGVwcy9hdXRvbWF0aW9uL2V4ZWN1dGUtc2NyaXB0LXN0ZXAnO1xuaW1wb3J0IHsgUHl0aG9uU2NyaXB0SGFuZGxlciB9IGZyb20gJy4uLy4uL3NjcmlwdC9weXRob24tc2NyaXB0LWhhbmRsZXInO1xuaW1wb3J0IHsgQXV0b21hdGlvblNpbXVsYXRpb25CYXNlIH0gZnJvbSAnLi9hdXRvbWF0aW9uLXNpbXVsYXRpb24tYmFzZSc7XG5cbi8qKlxuICogQXV0b21hdGlvblN0ZXAgaW1wbGVtZW50YXRpb24gZm9yIGF3czpleGVjdXRlU2NyaXB0XG4gKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc3lzdGVtcy1tYW5hZ2VyL2xhdGVzdC91c2VyZ3VpZGUvYXV0b21hdGlvbi1hY3Rpb24tZXhlY3V0ZVNjcmlwdC5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBFeGVjdXRlU2NyaXB0U2ltdWxhdGlvbiBleHRlbmRzIEF1dG9tYXRpb25TaW11bGF0aW9uQmFzZSB7XG5cbiAgcmVhZG9ubHkgYWN0aW9uOiBzdHJpbmcgPSAnYXdzOmV4ZWN1dGVTY3JpcHQnO1xuICByZWFkb25seSBleGVjdXRlU2NyaXB0U3RlcDogRXhlY3V0ZVNjcmlwdFN0ZXA7XG4gIGNvbnN0cnVjdG9yKHN0ZXA6IEV4ZWN1dGVTY3JpcHRTdGVwKSB7XG4gICAgc3VwZXIoc3RlcCk7XG4gICAgdGhpcy5leGVjdXRlU2NyaXB0U3RlcCA9IHN0ZXA7XG4gIH1cblxuICAvKipcbiAgICogUnVucyB0aGUgc2ltdWxhdGlvbi4gTmVzdHMgcmV0dXJuZWQgb2JqZWN0IGludG8gYSBcIlBheWxvYWRcIiBrZXkgdG8gbWltaWMgU1NNIGJlaGF2aW9yLlxuICAgKiBTd2l0Y2ggYnkgbGFuZ3VhZ2UgYW5kIGV4ZWN1dGUgY29kZSBiYXNlZCBvbiBzcGVjaWZpZWQgbGFuZ3VhZ2UuXG4gICAqL1xuICBwdWJsaWMgZXhlY3V0ZVN0ZXAoaW5wdXRzOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICBzd2l0Y2ggKHRoaXMuZXhlY3V0ZVNjcmlwdFN0ZXAubGFuZ3VhZ2UpIHtcbiAgICAgIGNhc2UgU2NyaXB0TGFuZ3VhZ2UuUFlUSE9OOlxuICAgICAgICBjb25zdCBweUhhbmRsZXIgPSBuZXcgUHl0aG9uU2NyaXB0SGFuZGxlcigpO1xuICAgICAgICByZXR1cm4gcHlIYW5kbGVyLnJ1bih0aGlzLmV4ZWN1dGVTY3JpcHRTdGVwLmZ1bGxQYXRoVG9Db2RlLCB0aGlzLmV4ZWN1dGVTY3JpcHRTdGVwLmhhbmRsZXJOYW1lLCBpbnB1dHMpO1xuICAgICAgZGVmYXVsdDpcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKGBMYW5ndWFnZSAke3RoaXMuZXhlY3V0ZVNjcmlwdFN0ZXAubGFuZ3VhZ2V9IG5vdCBzdXBwb3J0ZWQuYCk7XG4gICAgfVxuICB9XG5cbn0iXX0=