"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExecuteAutomationSimulation = void 0;
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implementation of [aws:executeAutomation](https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-executeAutomation.html)
 */
class ExecuteAutomationSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:executeAutomation';
        this.executeAutomationStep = step;
        this.props = props;
    }
    executeStep(inputs) {
        const props = {
            documentName: this.executeAutomationStep.documentName.resolveToString(inputs),
            documentVersion: this.executeAutomationStep.documentVersion?.resolveToString(inputs),
            maxConcurrency: this.executeAutomationStep.maxConcurrency?.resolveToString(inputs),
            maxErrors: this.executeAutomationStep.maxErrors?.resolveToString(inputs),
            runtimeParameters: this.executeAutomationStep.runtimeParameters?.resolveToStringMap(inputs),
            tags: this.executeAutomationStep.tags?.resolveToMapList(inputs),
            targetLocations: this.executeAutomationStep.targetLocations?.resolveToMapList(inputs),
            targetMaps: this.executeAutomationStep.targetMaps?.resolveToMapList(inputs),
            targetParameterName: this.executeAutomationStep.targetParameterName?.resolveToString(inputs),
            targets: this.executeAutomationStep.targets?.resolveToMapList(inputs),
        };
        console.log('ExecuteAutomation: Executing automation hook');
        const result = this.props.executeAutomationHook.execute(props);
        console.log('ExecuteAutomation: Finished executing hook');
        return {
            ExecutionId: result.executionId,
            Status: result.status,
            Output: result.output,
        };
    }
}
exports.ExecuteAutomationSimulation = ExecuteAutomationSimulation;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhlY3V0ZS1hdXRvbWF0aW9uLXNpbXVsYXRpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvc2ltdWxhdGlvbi9hdXRvbWF0aW9uL2V4ZWN1dGUtYXV0b21hdGlvbi1zaW11bGF0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLDZFQUF3RTtBQWF4RTs7R0FFRztBQUNILE1BQWEsMkJBQTRCLFNBQVEscURBQXdCO0lBS3ZFLFlBQVksSUFBMkIsRUFBRSxLQUF1QztRQUM5RSxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUM7UUFMTCxXQUFNLEdBQUcsdUJBQXVCLENBQUM7UUFNeEMsSUFBSSxDQUFDLHFCQUFxQixHQUFHLElBQUksQ0FBQztRQUNsQyxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBRU0sV0FBVyxDQUFDLE1BQTJCO1FBQzVDLE1BQU0sS0FBSyxHQUEyQjtZQUNwQyxZQUFZLEVBQUUsSUFBSSxDQUFDLHFCQUFxQixDQUFDLFlBQVksQ0FBQyxlQUFlLENBQUMsTUFBTSxDQUFDO1lBQzdFLGVBQWUsRUFBRSxJQUFJLENBQUMscUJBQXFCLENBQUMsZUFBZSxFQUFFLGVBQWUsQ0FBQyxNQUFNLENBQUM7WUFDcEYsY0FBYyxFQUFFLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxjQUFjLEVBQUUsZUFBZSxDQUFDLE1BQU0sQ0FBQztZQUNsRixTQUFTLEVBQUUsSUFBSSxDQUFDLHFCQUFxQixDQUFDLFNBQVMsRUFBRSxlQUFlLENBQUMsTUFBTSxDQUFDO1lBQ3hFLGlCQUFpQixFQUFFLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsQ0FBQyxNQUFNLENBQUM7WUFDM0YsSUFBSSxFQUFFLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLEVBQUUsZ0JBQWdCLENBQUMsTUFBTSxDQUFDO1lBQy9ELGVBQWUsRUFBRSxJQUFJLENBQUMscUJBQXFCLENBQUMsZUFBZSxFQUFFLGdCQUFnQixDQUFDLE1BQU0sQ0FBQztZQUNyRixVQUFVLEVBQUUsSUFBSSxDQUFDLHFCQUFxQixDQUFDLFVBQVUsRUFBRSxnQkFBZ0IsQ0FBQyxNQUFNLENBQUM7WUFDM0UsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLHFCQUFxQixDQUFDLG1CQUFtQixFQUFFLGVBQWUsQ0FBQyxNQUFNLENBQUM7WUFDNUYsT0FBTyxFQUFFLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxPQUFPLEVBQUUsZ0JBQWdCLENBQUMsTUFBTSxDQUFDO1NBQ3RFLENBQUM7UUFFRixPQUFPLENBQUMsR0FBRyxDQUFDLDhDQUE4QyxDQUFDLENBQUM7UUFDNUQsTUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDL0QsT0FBTyxDQUFDLEdBQUcsQ0FBQyw0Q0FBNEMsQ0FBQyxDQUFDO1FBRTFELE9BQU87WUFDTCxXQUFXLEVBQUUsTUFBTSxDQUFDLFdBQVc7WUFDL0IsTUFBTSxFQUFFLE1BQU0sQ0FBQyxNQUFNO1lBQ3JCLE1BQU0sRUFBRSxNQUFNLENBQUMsTUFBTTtTQUN0QixDQUFDO0lBQ0osQ0FBQztDQUVGO0FBcENELGtFQW9DQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEV4ZWN1dGVBdXRvbWF0aW9uUHJvcHMsIEV4ZWN1dGVBdXRvbWF0aW9uU3RlcCwgSUV4ZWN1dGVBdXRvbWF0aW9uSG9vayB9IGZyb20gJy4uLy4uJztcbmltcG9ydCB7IEF1dG9tYXRpb25TaW11bGF0aW9uQmFzZSB9IGZyb20gJy4vYXV0b21hdGlvbi1zaW11bGF0aW9uLWJhc2UnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIEV4ZWN1dGVBdXRvbWF0aW9uU3RlcFxuICovXG5leHBvcnQgaW50ZXJmYWNlIEV4ZWN1dGVBdXRvbWF0aW9uU2ltdWxhdGlvblByb3BzIHtcbiAgLyoqXG4gICAqIEhvb2sgZm9yIHNpbXVsYXRpbmcgYXdzOmV4ZWN1dGVBdXRvbWF0aW9uLlxuICAgKiBAZGVmYXVsdCAtIFVzZXMgQVdTIEFQSSB0byBleGVjdXRlIHRoZSBkb2N1bWVudCByZW1vdGVseS5cbiAgICovXG4gIHJlYWRvbmx5IGV4ZWN1dGVBdXRvbWF0aW9uSG9vazogSUV4ZWN1dGVBdXRvbWF0aW9uSG9vaztcbn1cblxuLyoqXG4gKiBBdXRvbWF0aW9uU3RlcCBpbXBsZW1lbnRhdGlvbiBvZiBbYXdzOmV4ZWN1dGVBdXRvbWF0aW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc3lzdGVtcy1tYW5hZ2VyL2xhdGVzdC91c2VyZ3VpZGUvYXV0b21hdGlvbi1hY3Rpb24tZXhlY3V0ZUF1dG9tYXRpb24uaHRtbClcbiAqL1xuZXhwb3J0IGNsYXNzIEV4ZWN1dGVBdXRvbWF0aW9uU2ltdWxhdGlvbiBleHRlbmRzIEF1dG9tYXRpb25TaW11bGF0aW9uQmFzZSB7XG4gIHJlYWRvbmx5IGFjdGlvbiA9ICdhd3M6ZXhlY3V0ZUF1dG9tYXRpb24nO1xuICBwcml2YXRlIGV4ZWN1dGVBdXRvbWF0aW9uU3RlcDogRXhlY3V0ZUF1dG9tYXRpb25TdGVwO1xuICBwcml2YXRlIHByb3BzOiBFeGVjdXRlQXV0b21hdGlvblNpbXVsYXRpb25Qcm9wcztcblxuICBjb25zdHJ1Y3RvcihzdGVwOiBFeGVjdXRlQXV0b21hdGlvblN0ZXAsIHByb3BzOiBFeGVjdXRlQXV0b21hdGlvblNpbXVsYXRpb25Qcm9wcykge1xuICAgIHN1cGVyKHN0ZXApO1xuICAgIHRoaXMuZXhlY3V0ZUF1dG9tYXRpb25TdGVwID0gc3RlcDtcbiAgICB0aGlzLnByb3BzID0gcHJvcHM7XG4gIH1cblxuICBwdWJsaWMgZXhlY3V0ZVN0ZXAoaW5wdXRzOiBSZWNvcmQ8c3RyaW5nLCBhbnk+KTogUmVjb3JkPHN0cmluZywgYW55PiB7XG4gICAgY29uc3QgcHJvcHM6IEV4ZWN1dGVBdXRvbWF0aW9uUHJvcHMgPSB7XG4gICAgICBkb2N1bWVudE5hbWU6IHRoaXMuZXhlY3V0ZUF1dG9tYXRpb25TdGVwLmRvY3VtZW50TmFtZS5yZXNvbHZlVG9TdHJpbmcoaW5wdXRzKSxcbiAgICAgIGRvY3VtZW50VmVyc2lvbjogdGhpcy5leGVjdXRlQXV0b21hdGlvblN0ZXAuZG9jdW1lbnRWZXJzaW9uPy5yZXNvbHZlVG9TdHJpbmcoaW5wdXRzKSxcbiAgICAgIG1heENvbmN1cnJlbmN5OiB0aGlzLmV4ZWN1dGVBdXRvbWF0aW9uU3RlcC5tYXhDb25jdXJyZW5jeT8ucmVzb2x2ZVRvU3RyaW5nKGlucHV0cyksXG4gICAgICBtYXhFcnJvcnM6IHRoaXMuZXhlY3V0ZUF1dG9tYXRpb25TdGVwLm1heEVycm9ycz8ucmVzb2x2ZVRvU3RyaW5nKGlucHV0cyksXG4gICAgICBydW50aW1lUGFyYW1ldGVyczogdGhpcy5leGVjdXRlQXV0b21hdGlvblN0ZXAucnVudGltZVBhcmFtZXRlcnM/LnJlc29sdmVUb1N0cmluZ01hcChpbnB1dHMpLFxuICAgICAgdGFnczogdGhpcy5leGVjdXRlQXV0b21hdGlvblN0ZXAudGFncz8ucmVzb2x2ZVRvTWFwTGlzdChpbnB1dHMpLFxuICAgICAgdGFyZ2V0TG9jYXRpb25zOiB0aGlzLmV4ZWN1dGVBdXRvbWF0aW9uU3RlcC50YXJnZXRMb2NhdGlvbnM/LnJlc29sdmVUb01hcExpc3QoaW5wdXRzKSxcbiAgICAgIHRhcmdldE1hcHM6IHRoaXMuZXhlY3V0ZUF1dG9tYXRpb25TdGVwLnRhcmdldE1hcHM/LnJlc29sdmVUb01hcExpc3QoaW5wdXRzKSxcbiAgICAgIHRhcmdldFBhcmFtZXRlck5hbWU6IHRoaXMuZXhlY3V0ZUF1dG9tYXRpb25TdGVwLnRhcmdldFBhcmFtZXRlck5hbWU/LnJlc29sdmVUb1N0cmluZyhpbnB1dHMpLFxuICAgICAgdGFyZ2V0czogdGhpcy5leGVjdXRlQXV0b21hdGlvblN0ZXAudGFyZ2V0cz8ucmVzb2x2ZVRvTWFwTGlzdChpbnB1dHMpLFxuICAgIH07XG5cbiAgICBjb25zb2xlLmxvZygnRXhlY3V0ZUF1dG9tYXRpb246IEV4ZWN1dGluZyBhdXRvbWF0aW9uIGhvb2snKTtcbiAgICBjb25zdCByZXN1bHQgPSB0aGlzLnByb3BzLmV4ZWN1dGVBdXRvbWF0aW9uSG9vay5leGVjdXRlKHByb3BzKTtcbiAgICBjb25zb2xlLmxvZygnRXhlY3V0ZUF1dG9tYXRpb246IEZpbmlzaGVkIGV4ZWN1dGluZyBob29rJyk7XG5cbiAgICByZXR1cm4ge1xuICAgICAgRXhlY3V0aW9uSWQ6IHJlc3VsdC5leGVjdXRpb25JZCxcbiAgICAgIFN0YXR1czogcmVzdWx0LnN0YXR1cyxcbiAgICAgIE91dHB1dDogcmVzdWx0Lm91dHB1dCxcbiAgICB9O1xuICB9XG5cbn0iXX0=