"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HelloWorld = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const automation_document_1 = require("../document/automation-document");
const data_type_1 = require("../domain/data-type");
const string_variable_1 = require("../interface/variables/string-variable");
const aws_api_step_1 = require("../parent-steps/automation/aws-api-step");
const execute_script_step_1 = require("../parent-steps/automation/execute-script-step");
class HelloWorld extends aws_cdk_lib_1.Stack {
    constructor(app, id) {
        super(app, id);
        const doc = new automation_document_1.AutomationDocument(this, 'HelloWorld', {
            docInputs: [{
                    name: 'Someone',
                    inputType: data_type_1.DataTypeEnum.STRING,
                    allowedPattern: '[a-zA-Z]+',
                },
                {
                    name: 'SnsTopic',
                    inputType: data_type_1.DataTypeEnum.STRING,
                }],
        });
        const greeting = new execute_script_step_1.ExecuteScriptStep(this, 'PrependWithGreeting', {
            language: execute_script_step_1.ScriptLanguage.PYTHON,
            inlineCode: 'def my_func(args, context):\n' +
                '    return {"Greeting": "Hello " + args["Someone"]}\n' +
                '\n',
            handlerName: 'my_func',
            inputs: ['Someone'],
            outputs: [{
                    outputType: data_type_1.DataTypeEnum.STRING,
                    name: 'Greeting',
                    selector: '$.Payload.Greeting',
                }],
        });
        doc.addStep(greeting);
        doc.addStep(new aws_api_step_1.AwsApiStep(this, 'PublishToSns', {
            outputs: [],
            service: 'SNS',
            pascalCaseApi: 'publish',
            apiParams: {
                TargetArn: new string_variable_1.StringVariable('SnsTopic'),
                Message: greeting.variables().Greeting,
            },
        }));
    }
}
exports.HelloWorld = HelloWorld;
_a = JSII_RTTI_SYMBOL_1;
HelloWorld[_a] = { fqn: "@cdklabs/cdk-ssm-documents.HelloWorld", version: "0.0.13" };
//# sourceMappingURL=data:application/json;base64,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