"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunShellScriptStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * AutomationStep implemenation for aws:sleep
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-sleep.html
 */
class RunShellScriptStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.MAC_OS, platform_1.Platform.LINUX];
        this.action = 'aws:runShellScript';
        this.runCommand = props.runCommand;
        this.timeoutSeconds = props.timeoutSeconds;
        this.workingDirectory = props.workingDirectory;
    }
    /**
       * Inputs required for this command includes both the runCommand variables and workingDirectory if provided.
       */
    listInputs() {
        return [
            ...this.runCommand.flatMap(v => v.requiredInputs()),
            ...this.workingDirectory?.requiredInputs() ?? [],
        ];
    }
    toSsmEntry() {
        const inputs = { runCommand: this.runCommand };
        if (this.workingDirectory != undefined) {
            inputs.workingDirectory = this.workingDirectory;
        }
        if (this.timeoutSeconds != undefined) {
            inputs.timeoutSeconds = this.timeoutSeconds;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.RunShellScriptStep = RunShellScriptStep;
_a = JSII_RTTI_SYMBOL_1;
RunShellScriptStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.RunShellScriptStep", version: "0.0.13" };
//# sourceMappingURL=data:application/json;base64,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