"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DownloadContentStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * AutomationStep implemenation for aws:downloadContent
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-downloadContent
 */
class DownloadContentStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX];
        this.action = 'aws:downloadContent';
        this.downloadableContent = props.downloadableContent;
        this.destinationPath = props.destinationPath;
    }
    /**
     * Inputs required for this command includes both the sourceType and sourceInfo variables and  destinationPath if provided.
     */
    listInputs() {
        return [
            ...this.destinationPath?.requiredInputs() ?? [],
            ...this.downloadableContent.requiredInputs(),
        ];
    }
    toSsmEntry() {
        const inputs = {
            sourceType: this.downloadableContent.sourceType,
            sourceInfo: this.downloadableContent.formatSourceInfo(),
        };
        if (this.destinationPath != undefined) {
            inputs.destinationPath = this.destinationPath;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.DownloadContentStep = DownloadContentStep;
_a = JSII_RTTI_SYMBOL_1;
DownloadContentStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.DownloadContentStep", version: "0.0.13" };
//# sourceMappingURL=data:application/json;base64,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