import { Construct } from 'constructs';
import { IInstallUninstallRepairVariable } from '../../domain/enum/install-uninstall-repair';
import { Platform } from '../../domain/platform';
import { IStringVariable } from '../../interface/variables/string-variable';
import { CommandStep, CommandStepProps } from '../command-step';
export interface ApplicationsStepProps extends CommandStepProps {
    readonly action: IInstallUninstallRepairVariable;
    readonly parameters?: IStringVariable;
    readonly source: IStringVariable;
    readonly sourceHash?: IStringVariable;
}
/**
 * CommandStep implemenation for aws:applications
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-applications
 */
export declare class ApplicationsStep extends CommandStep {
    readonly installAction: IInstallUninstallRepairVariable;
    readonly parameters?: IStringVariable;
    readonly source: IStringVariable;
    readonly sourceHash?: IStringVariable;
    readonly platforms: Platform[];
    readonly action = "aws:applications";
    constructor(scope: Construct, id: string, props: ApplicationsStepProps);
    listInputs(): string[];
    toSsmEntry(): {
        [name: string]: any;
    };
}
