"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteStackStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implemenation for aws:deleteStack
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-deletestack.html
 */
class DeleteStackStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:deleteStack';
        this.roleArn = props.roleArn;
        this.stackNameVariable = props.stackNameVariable;
    }
    /**
       * No outputs emitted from Delete Stack step
       * @returns []
       */
    listOutputs() {
        return [];
    }
    /**
       * The input required for this step is the stackNameVariable.
       * @returns the stackNameVariable as declared in the constructor
       */
    listInputs() {
        return [
            ...this.stackNameVariable.requiredInputs(),
            ...this.roleArn == undefined ? [] : this.roleArn.requiredInputs(),
        ];
    }
    toSsmEntry() {
        const inputs = {
            StackName: this.stackNameVariable.print(),
            ClientRequestToken: `${this.stackNameVariable.print()}{{automation:EXECUTION_ID}}`,
        };
        if (this.roleArn != undefined) {
            inputs.RoleARN = this.roleArn;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.DeleteStackStep = DeleteStackStep;
_a = JSII_RTTI_SYMBOL_1;
DeleteStackStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.DeleteStackStep", version: "0.0.13" };
//# sourceMappingURL=data:application/json;base64,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