# coding: utf-8

# flake8: noqa

"""
    MONEI API v1

    <p>The MONEI API is organized around <a href=\"https://en.wikipedia.org/wiki/Representational_State_Transfer\">REST</a>. Our API has predictable resource-oriented URLs, accepts JSON-encoded request bodies, returns JSON-encoded responses, and uses standard HTTP response codes, authentication, and verbs.</p> <h4 id=\"base-url\">Base URL:</h4> <p><a href=\"https://api.monei.com/v1\">https://api.monei.com/v1</a></p> <h4 id=\"client-libraries\">Client libraries:</h4> <ul> <li><a href=\"https://github.com/MONEI/monei-php-sdk\">PHP SDK</a></li> <li><a href=\"https://github.com/MONEI/monei-python-sdk\">Python SDK</a></li> <li><a href=\"https://github.com/MONEI/monei-node-sdk\">Node.js SDK</a></li> <li><a href=\"https://postman.monei.com/\">Postman Collection</a></li> </ul>   # noqa: E501

    The version of the OpenAPI document: 1.2.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

__version__ = "1.0.6"

# import apis into sdk package
from Monei.api.apple_pay_domain_api import ApplePayDomainApi
from Monei.api.payments_api import PaymentsApi
from Monei.api.subscriptions_api import SubscriptionsApi

# import ApiClient
from Monei.api_client import ApiClient
from Monei.configuration import Configuration
from Monei.exceptions import OpenApiException
from Monei.exceptions import ApiTypeError
from Monei.exceptions import ApiValueError
from Monei.exceptions import ApiKeyError
from Monei.exceptions import ApiException
# import models into sdk package
from Monei.models.activate_subscription_request import ActivateSubscriptionRequest
from Monei.models.address import Address
from Monei.models.cancel_payment_request import CancelPaymentRequest
from Monei.models.cancel_subscription_request import CancelSubscriptionRequest
from Monei.models.capture_payment_request import CapturePaymentRequest
from Monei.models.card import Card
from Monei.models.confirm_payment_request import ConfirmPaymentRequest
from Monei.models.confirm_payment_request_payment_method import ConfirmPaymentRequestPaymentMethod
from Monei.models.confirm_payment_request_payment_method_card import ConfirmPaymentRequestPaymentMethodCard
from Monei.models.create_payment_request import CreatePaymentRequest
from Monei.models.create_subscription_request import CreateSubscriptionRequest
from Monei.models.error import Error
from Monei.models.inline_response200 import InlineResponse200
from Monei.models.pause_subscription_request import PauseSubscriptionRequest
from Monei.models.payment import Payment
from Monei.models.payment_billing_details import PaymentBillingDetails
from Monei.models.payment_cancellation_reason import PaymentCancellationReason
from Monei.models.payment_customer import PaymentCustomer
from Monei.models.payment_last_refund_reason import PaymentLastRefundReason
from Monei.models.payment_next_action import PaymentNextAction
from Monei.models.payment_payment_method import PaymentPaymentMethod
from Monei.models.payment_payment_method_bizum import PaymentPaymentMethodBizum
from Monei.models.payment_payment_method_card import PaymentPaymentMethodCard
from Monei.models.payment_payment_method_cofidis import PaymentPaymentMethodCofidis
from Monei.models.payment_payment_method_input import PaymentPaymentMethodInput
from Monei.models.payment_payment_method_paypal import PaymentPaymentMethodPaypal
from Monei.models.payment_refund_reason import PaymentRefundReason
from Monei.models.payment_sequence import PaymentSequence
from Monei.models.payment_sequence_recurring import PaymentSequenceRecurring
from Monei.models.payment_session_details import PaymentSessionDetails
from Monei.models.payment_shipping_details import PaymentShippingDetails
from Monei.models.payment_shop import PaymentShop
from Monei.models.payment_status import PaymentStatus
from Monei.models.payment_trace_details import PaymentTraceDetails
from Monei.models.payment_transaction_type import PaymentTransactionType
from Monei.models.recurring_payment_request import RecurringPaymentRequest
from Monei.models.refund_payment_request import RefundPaymentRequest
from Monei.models.register_domain_request import RegisterDomainRequest
from Monei.models.send_payment_link_request import SendPaymentLinkRequest
from Monei.models.send_payment_receipt_request import SendPaymentReceiptRequest
from Monei.models.subscription import Subscription
from Monei.models.subscription_interval import SubscriptionInterval
from Monei.models.subscription_last_payment import SubscriptionLastPayment
from Monei.models.subscription_payment_method import SubscriptionPaymentMethod
from Monei.models.subscription_payment_method_card import SubscriptionPaymentMethodCard
from Monei.models.subscription_status import SubscriptionStatus
from Monei.models.update_subscription_request import UpdateSubscriptionRequest

# import custom MoneiClient
from Monei.monei_client import MoneiClient
