# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from pygfe.models.base_model_ import Model
from pygfe.models.feature import Feature  # noqa: F401,E501
from pygfe.models.seqdiff import Seqdiff  # noqa: F401,E501
from seqann import util


class Typing(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, seqdiff: List[Seqdiff]=None, protdiff: List[Seqdiff]=None, novel_features: List[Feature]=None, features: List[Feature]=None, gfe: str=None, hla: str=None, closest_gfe: str=None, full_gene_accession: int=None, differences: int=None, status: str=None, seqann_version: str=None, pygfe_version: str=None, gfedb_version: str=None, imgtdb_version: str=None):  # noqa: E501
        """Typing - a model defined in Swagger

        :param seqdiff: The seqdiff of this Typing.  # noqa: E501
        :type seqdiff: List[Seqdiff]
        :param protdiff: The protdiff of this Typing.  # noqa: E501
        :type protdiff: List[Seqdiff]
        :param features: The features of this Typing.  # noqa: E501
        :type features: List[Feature]
        :param gfe: The gfe of this Typing.  # noqa: E501
        :type gfe: str
        :param hla: The hla of this Typing.  # noqa: E501
        :type hla: str
        :param closest_gfe: The closest_gfe of this Typing.  # noqa: E501
        :type closest_gfe: str
        :param full_gene_accession: The full_gene_accession of this Typing.  # noqa: E501
        :type full_gene_accession: int
        :param differences: The differences of this Typing.  # noqa: E501
        :type differences: int
        :param status: The status of this Typing.  # noqa: E501
        :type status: str
        :param pygfe_version: The pygfe_version of this Typing.  # noqa: E501
        :type pygfe_version: str
        :param gfedb_version: The gfedb_version of this Typing.  # noqa: E501
        :type gfedb_version: str
        :param imgtdb_version: The imgtdb_version of this Typing.  # noqa: E501
        :type imgtdb_version: str
        """
        self.swagger_types = {
            'seqdiff': List[Seqdiff],
            'protdiff': List[Seqdiff],
            'features': List[Feature],
            'novel_features': List[Feature],
            'gfe': str,
            'hla': str,
            'closest_gfe': str,
            'full_gene_accession': int,
            'differences': int,
            'status': str,
            'pygfe_version': str,
            'gfedb_version': str,
            'imgtdb_version': str,
            'seqann_version': str
        }

        self.attribute_map = {
            'seqdiff': 'seqdiff',
            'protdiff': 'protdiff',
            'features': 'features',
            'novel_features': 'novel_features',
            'gfe': 'gfe',
            'hla': 'hla',
            'closest_gfe': 'closest_gfe',
            'full_gene_accession': 'full_gene_accession',
            'differences': 'differences',
            'status': 'status',
            'pygfe_version': 'pygfe_version',
            'gfedb_version': 'gfedb_version',
            'imgtdb_version': 'imgtdb_version',
            'seqann_version': 'seqann_version'
        }

        self._seqann_version = seqann_version
        self._seqdiff = seqdiff
        self._protdiff = protdiff
        self._features = features
        self._novel_features = novel_features
        self._gfe = gfe
        self._hla = hla
        self._closest_gfe = closest_gfe
        self._full_gene_accession = full_gene_accession
        self._differences = differences
        self._status = status
        self._pygfe_version = pygfe_version
        self._gfedb_version = gfedb_version
        self._imgtdb_version = imgtdb_version

    @classmethod
    def from_dict(cls, dikt) -> 'Typing':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Typing of this Typing.  # noqa: E501
        :rtype: Typing
        """
        return util.deserialize_model(dikt, cls)

    @property
    def seqdiff(self) -> List[Seqdiff]:
        """Gets the seqdiff of this Typing.


        :return: The seqdiff of this Typing.
        :rtype: List[Seqdiff]
        """
        return self._seqdiff

    @seqdiff.setter
    def seqdiff(self, seqdiff: List[Seqdiff]):
        """Sets the seqdiff of this Typing.


        :param seqdiff: The seqdiff of this Typing.
        :type seqdiff: List[Seqdiff]
        """

        self._seqdiff = seqdiff

    @property
    def protdiff(self) -> List[Seqdiff]:
        """Gets the protdiff of this Typing.


        :return: The protdiff of this Typing.
        :rtype: List[Seqdiff]
        """
        return self._protdiff

    @protdiff.setter
    def protdiff(self, protdiff: List[Seqdiff]):
        """Sets the protdiff of this Typing.


        :param protdiff: The protdiff of this Typing.
        :type protdiff: List[Seqdiff]
        """

        self._protdiff = protdiff

    @property
    def features(self) -> List[Feature]:
        """Gets the features of this Typing.


        :return: The features of this Typing.
        :rtype: List[Feature]
        """
        return self._features

    @features.setter
    def features(self, features: List[Feature]):
        """Sets the features of this Typing.


        :param features: The features of this Typing.
        :type features: List[Feature]
        """

        self._features = features

    @property
    def novel_features(self) -> List[Feature]:
        """Gets the novel_features of this Typing.


        :return: The novel_features of this Typing.
        :rtype: List[Feature]
        """
        return self._novel_features

    @novel_features.setter
    def novel_features(self, novel_features: List[Feature]):
        """Sets the novel_features of this Typing.


        :param novel_features: The novel_features of this Typing.
        :type novel_features: List[Feature]
        """

        self._novel_features = novel_features

    @property
    def gfe(self) -> str:
        """Gets the gfe of this Typing.


        :return: The gfe of this Typing.
        :rtype: str
        """
        return self._gfe

    @gfe.setter
    def gfe(self, gfe: str):
        """Sets the gfe of this Typing.


        :param gfe: The gfe of this Typing.
        :type gfe: str
        """

        self._gfe = gfe

    @property
    def hla(self) -> str:
        """Gets the hla of this Typing.


        :return: The hla of this Typing.
        :rtype: str
        """
        return self._hla

    @hla.setter
    def hla(self, hla: str):
        """Sets the hla of this Typing.


        :param hla: The hla of this Typing.
        :type hla: str
        """

        self._hla = hla

    @property
    def closest_gfe(self) -> str:
        """Gets the closest_gfe of this Typing.


        :return: The closest_gfe of this Typing.
        :rtype: str
        """
        return self._closest_gfe

    @closest_gfe.setter
    def closest_gfe(self, closest_gfe: str):
        """Sets the closest_gfe of this Typing.


        :param closest_gfe: The closest_gfe of this Typing.
        :type closest_gfe: str
        """

        self._closest_gfe = closest_gfe

    @property
    def full_gene_accession(self) -> int:
        """Gets the full_gene_accession of this Typing.


        :return: The full_gene_accession of this Typing.
        :rtype: int
        """
        return self._full_gene_accession

    @full_gene_accession.setter
    def full_gene_accession(self, full_gene_accession: int):
        """Sets the full_gene_accession of this Typing.


        :param full_gene_accession: The full_gene_accession of this Typing.
        :type full_gene_accession: int
        """

        self._full_gene_accession = full_gene_accession

    @property
    def differences(self) -> int:
        """Gets the differences of this Typing.


        :return: The differences of this Typing.
        :rtype: int
        """
        return self._differences

    @differences.setter
    def differences(self, differences: int):
        """Sets the differences of this Typing.


        :param differences: The differences of this Typing.
        :type differences: int
        """

        self._differences = differences

    @property
    def status(self) -> str:
        """Gets the status of this Typing.


        :return: The status of this Typing.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str):
        """Sets the status of this Typing.


        :param status: The status of this Typing.
        :type status: str
        """

        self._status = status

    @property
    def pygfe_version(self) -> str:
        """Gets the pygfe_version of this Typing.


        :return: The pygfe_version of this Typing.
        :rtype: str
        """
        return self._pygfe_version

    @pygfe_version.setter
    def pygfe_version(self, pygfe_version: str):
        """Sets the pygfe_version of this Typing.


        :param pygfe_version: The pygfe_version of this Typing.
        :type pygfe_version: str
        """

        self._pygfe_version = pygfe_version

    @property
    def gfedb_version(self) -> str:
        """Gets the gfedb_version of this Typing.


        :return: The gfedb_version of this Typing.
        :rtype: str
        """
        return self._gfedb_version

    @gfedb_version.setter
    def gfedb_version(self, gfedb_version: str):
        """Sets the gfedb_version of this Typing.


        :param gfedb_version: The gfedb_version of this Typing.
        :type gfedb_version: str
        """

        self._gfedb_version = gfedb_version

    @property
    def seqann_version(self) -> str:
        """Gets the seqann_version of this Typing.


        :return: The seqann_version of this Typing.
        :rtype: str
        """
        return self._seqann_version

    @seqann_version.setter
    def seqann_version(self, seqann_version: str):
        """Sets the seqann_version of this Typing.


        :param seqann_version: The seqann_version of this Typing.
        :type seqann_version: str
        """

        self._seqann_version = seqann_version

    @property
    def imgtdb_version(self) -> str:
        """Gets the imgtdb_version of this Typing.


        :return: The imgtdb_version of this Typing.
        :rtype: str
        """
        return self._imgtdb_version

    @imgtdb_version.setter
    def imgtdb_version(self, imgtdb_version: str):
        """Sets the imgtdb_version of this Typing.


        :param imgtdb_version: The imgtdb_version of this Typing.
        :type imgtdb_version: str
        """

        self._imgtdb_version = imgtdb_version
