import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a BigID S3 data source
 *
 * @schema CfnS3Props
 */
export interface CfnS3Props {
    /**
     * @schema CfnS3Props#Name
     */
    readonly name: string;
    /**
     * @schema CfnS3Props#Enabled
     */
    readonly enabled?: boolean;
    /**
     * @schema CfnS3Props#FriendlyName
     */
    readonly friendlyName?: string;
    /**
     * @schema CfnS3Props#Description
     */
    readonly description?: string;
    /**
     * @schema CfnS3Props#AwsAuthenticationType
     */
    readonly awsAuthenticationType?: AwsAuthenticationType;
    /**
     * @schema CfnS3Props#AwsRoleSessionName
     */
    readonly awsRoleSessionName?: string;
    /**
     * @schema CfnS3Props#AwsRoleArn
     */
    readonly awsRoleArn?: string;
    /**
     * @schema CfnS3Props#AwsAccessKey
     */
    readonly awsAccessKey?: string;
    /**
     * @schema CfnS3Props#AwsSecretKey
     */
    readonly awsSecretKey?: string;
    /**
     * @schema CfnS3Props#AwsSessionToken
     */
    readonly awsSessionToken?: string;
    /**
     * @schema CfnS3Props#AwsRegion
     */
    readonly awsRegion?: string;
    /**
     * @schema CfnS3Props#BucketName
     */
    readonly bucketName?: string;
    /**
     * @schema CfnS3Props#IncludeExcludeFiles
     */
    readonly includeExcludeFiles?: boolean;
    /**
     * @schema CfnS3Props#FileTypesToExclude
     */
    readonly fileTypesToExclude?: string;
    /**
     * @schema CfnS3Props#FolderToScan
     */
    readonly folderToScan?: string;
    /**
     * @schema CfnS3Props#ScannerGroup
     */
    readonly scannerGroup?: string;
    /**
     * @schema CfnS3Props#TestConnectionTimeoutInSeconds
     */
    readonly testConnectionTimeoutInSeconds?: number;
    /**
     * @schema CfnS3Props#CustomFields
     */
    readonly customFields?: CustomField[];
    /**
     * @schema CfnS3Props#BusinessOwners
     */
    readonly businessOwners?: User[];
    /**
     * @schema CfnS3Props#ItOwners
     */
    readonly itOwners?: User[];
    /**
     * @schema CfnS3Props#Location
     */
    readonly location?: string;
    /**
     * @schema CfnS3Props#Scope
     */
    readonly scope?: string;
    /**
     * @schema CfnS3Props#SecurityTier
     */
    readonly securityTier?: SecurityTier;
    /**
     * @schema CfnS3Props#Comments
     */
    readonly comments?: string;
    /**
     * @schema CfnS3Props#NumberOfParsingThreads
     */
    readonly numberOfParsingThreads?: string;
    /**
     * @schema CfnS3Props#MetadataAclScanEnabled
     */
    readonly metadataAclScanEnabled?: boolean;
    /**
     * @schema CfnS3Props#DsAclScanEnabled
     */
    readonly dsAclScanEnabled?: boolean;
    /**
     * @schema CfnS3Props#EnabledOcr
     */
    readonly enabledOcr?: boolean;
    /**
     * @schema CfnS3Props#OcrTimeout
     */
    readonly ocrTimeout?: number;
    /**
     * @schema CfnS3Props#OcrLanguages
     */
    readonly ocrLanguages?: OcrLanguages;
    /**
     * @schema CfnS3Props#EnableClustering
     */
    readonly enableClustering?: boolean;
    /**
     * @schema CfnS3Props#EnableClassifiers
     */
    readonly enableClassifiers?: boolean;
    /**
     * @schema CfnS3Props#EnableAdvanceClassifiers
     */
    readonly enableAdvanceClassifiers?: boolean;
    /**
     * @schema CfnS3Props#SampleFolders
     */
    readonly sampleFolders?: boolean;
    /**
     * @schema CfnS3Props#SamplePercentage
     */
    readonly samplePercentage?: string;
    /**
     * @schema CfnS3Props#SampleFileContent
     */
    readonly sampleFileContent?: boolean;
    /**
     * @schema CfnS3Props#DifferentialScan
     */
    readonly differentialScan?: boolean;
    /**
     * @schema CfnS3Props#IsModifiedInXDays
     */
    readonly isModifiedInXDays?: boolean;
    /**
     * @schema CfnS3Props#XLastDays
     */
    readonly xLastDays?: number;
    /**
     * @schema CfnS3Props#ScanWindowName
     */
    readonly scanWindowName?: string;
    /**
     * @schema CfnS3Props#ParquetFileRegex
     */
    readonly parquetFileRegex?: string;
}
/**
 * Converts an object of type 'CfnS3Props' to JSON representation.
 */
export declare function toJson_CfnS3Props(obj: CfnS3Props | undefined): Record<string, any> | undefined;
/**
 * AWS Authentication Type
 *
 * @schema AwsAuthenticationType
 */
export declare enum AwsAuthenticationType {
    /** isCredentialsAuth */
    IS_CREDENTIALS_AUTH = "isCredentialsAuth",
    /** isIamRoleAuth */
    IS_IAM_ROLE_AUTH = "isIamRoleAuth",
    /** isAnonymousAuth */
    IS_ANONYMOUS_AUTH = "isAnonymousAuth",
    /** isCrossAccountAuth */
    IS_CROSS_ACCOUNT_AUTH = "isCrossAccountAuth",
    /** isSTSAuth */
    IS_STS_AUTH = "isSTSAuth"
}
/**
 * @schema CustomField
 */
export interface CustomField {
    /**
     * @schema CustomField#Name
     */
    readonly name?: string;
    /**
     * @schema CustomField#Value
     */
    readonly value?: string;
    /**
     * @schema CustomField#Encoded
     */
    readonly encoded?: string;
    /**
     * @schema CustomField#Type
     */
    readonly type?: CustomFieldType;
}
/**
 * Converts an object of type 'CustomField' to JSON representation.
 */
export declare function toJson_CustomField(obj: CustomField | undefined): Record<string, any> | undefined;
/**
 * @schema User
 */
export interface User {
    /**
     * @schema User#Id
     */
    readonly id?: string;
    /**
     * @schema User#Origin
     */
    readonly origin?: string;
    /**
     * @schema User#Email
     */
    readonly email?: string;
}
/**
 * Converts an object of type 'User' to JSON representation.
 */
export declare function toJson_User(obj: User | undefined): Record<string, any> | undefined;
/**
 * Security Tier
 *
 * @schema SecurityTier
 */
export declare enum SecurityTier {
    /** 1 */
    VALUE_1 = "1",
    /** 2 */
    VALUE_2 = "2",
    /** 3 */
    VALUE_3 = "3",
    /** 4 */
    VALUE_4 = "4",
    /** 5 */
    VALUE_5 = "5"
}
/**
 * OCR Languages (only used when "EnabledOcr" is set to "true")
 *
 * @schema OcrLanguages
 */
export declare enum OcrLanguages {
    /** eng */
    ENG = "eng",
    /** chi_sim+chi_tra */
    CHI_SIM_CHI_TRA = "chi_sim+chi_tra",
    /** ind */
    IND = "ind",
    /** jpn */
    JPN = "jpn",
    /** kor */
    KOR = "kor",
    /** tha */
    THA = "tha",
    /** vie */
    VIE = "vie",
    /** deu */
    DEU = "deu",
    /** fra */
    FRA = "fra",
    /** bul */
    BUL = "bul"
}
/**
 * @schema CustomFieldType
 */
export declare enum CustomFieldType {
    /** clear */
    CLEAR = "clear",
    /** encrypted */
    ENCRYPTED = "encrypted"
}
/**
 * A CloudFormation `BigID::DataSource::S3`
 *
 * @cloudformationResource BigID::DataSource::S3
 * @stability external
 * @link https://github.com/aws-cloudformation/aws-cloudformation-rpdk.git
 */
export declare class CfnS3 extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "BigID::DataSource::S3";
    /**
     * Resource props.
     */
    readonly props: CfnS3Props;
    /**
     * Create a new `BigID::DataSource::S3`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnS3Props);
}
