URL = "https://%s"
DEFAULT_DOMAIN = "%s.datomize.com"

MANAGEMENT = "/api"
ONBOARDING = "/onboarding"
IDENTITY = "/identity"
KEYCLOAK = "/auth"

VERSION = "/v1"
TENANT = "/tenant"


TOKEN_RESOLVER = "/tokenResolver"
REALM_NAME = "/realmName"

KEYCLOAK_BASE_URL = URL + KEYCLOAK + "/realms/%s/protocol/openid-connect/"
KEYCLOAK_GET_TOKEN_URL = KEYCLOAK_BASE_URL + "token"
KEYCLOAK_LOGOUT_URL = KEYCLOAK_BASE_URL + "logout"


ONBOARDING_GET_USER_DOMAIN_DEFAULT = (URL % DEFAULT_DOMAIN) \
                                     + ONBOARDING + VERSION + TENANT + "/getDefaultTenantDomainByKey/%s"

IDENTITY_GET_REALM_BY_DOMAIN = URL + IDENTITY + TOKEN_RESOLVER + REALM_NAME

# Temp
FLOWS_FILTER = "/flowsFilter"
LATEST_FLOWS = "/latestFlows"
MANAGEMENT_GET_LATEST_FLOWS = URL + MANAGEMENT + FLOWS_FILTER + LATEST_FLOWS


DATASOURCE_URL = "/dataSourceConfigurations"
ORIGIN_DS = "/origin"
TARGET_DS = "/target"
PRIVATE = "/private"
PRESIGNED_URL = "/presignedUrl"
MANAGEMENT_POST_ADD_ORIGIN_PRIVATE_DATASOURCE = URL + MANAGEMENT + DATASOURCE_URL + ORIGIN_DS + PRIVATE
MANAGEMENT_POST_ADD_TARGET_PRIVATE_DATASOURCE = URL + MANAGEMENT + DATASOURCE_URL + TARGET_DS + PRIVATE
MANAGEMENT_GET_PUT_PRESIGNED_URL = URL + MANAGEMENT + DATASOURCE_URL + ORIGIN_DS + PRIVATE + "/%s" + PRESIGNED_URL + "/%s"

PROTO = "/proto"
BUSINESS_UNIT_URL = "/businessUnit"
PROJECT_URL = "/projects"
GENERATIVE_MODEL = "/generativeModelFlows"
SYNTH_FLOW = "/synthesizeFlows"
FLOWS_URL = "/flows"
AUTO_SCHEMA_DISCOVERY = "/autoSchemaDiscovery"
SAMPLE_DATA_CSV = "/sampleTableCSV"
GENERATED_DATA_CSV = "/generatedTableCSV"
TRAIN = "/train"
TRAIN_AND_GENERATE = "/trainAndGenerate"
ENHANCE_ML = "/enhanceMLFlows"
ENHANCE_ML_EVALUATE = "/enhancedMLEvaluate"
ENHANCE_ML_TRAIN_GEN = "/enhancedMLTrainAndGenerate"
MODEL = "/models"
SAMPLE_TABLE = "/sampleTable"
GENERATED_DATA = "/generatedData"
SYNTHESIZE = "/synthesize"

SINGLE_PROJECT_URL = URL + MANAGEMENT + BUSINESS_UNIT_URL + "/%s" + PROJECT_URL + "/%s"

MANAGEMENT_GET_ALL_BUSINESS_UNIT_URL = URL + MANAGEMENT + BUSINESS_UNIT_URL
MANAGEMENT_GET_GENERATIVE_FLOW = SINGLE_PROJECT_URL + GENERATIVE_MODEL + "/%s"
MANAGEMENT_GET_SYNTH_FLOW = SINGLE_PROJECT_URL + SYNTH_FLOW + "/%s"
MANAGEMENT_POST_ADD_FLOW = SINGLE_PROJECT_URL + GENERATIVE_MODEL
MANAGEMENT_GET_SCHEMA_DISCOVERY = SINGLE_PROJECT_URL + FLOWS_URL + "/%s" + AUTO_SCHEMA_DISCOVERY
MANAGEMENT_PUT_TRAIN_FLOW = SINGLE_PROJECT_URL + GENERATIVE_MODEL + "/%s" + TRAIN_AND_GENERATE
MANAGEMENT_PUT_ENHANCE_ML_EVALUATE_FLOW = SINGLE_PROJECT_URL + ENHANCE_ML + "/%s" + ENHANCE_ML_EVALUATE
MANAGEMENT_PUT_ENHANCE_ML_TRAIN_GEN_FLOW = SINGLE_PROJECT_URL + ENHANCE_ML + "/%s" + ENHANCE_ML_TRAIN_GEN
MANAGEMENT_GET_GENERATIVE_SAMPLE = SINGLE_PROJECT_URL + GENERATIVE_MODEL + "/%s" + MODEL + "/%s" + SAMPLE_TABLE + "/%s"
MANAGEMENT_GET_GENERATED_DATA = SINGLE_PROJECT_URL + SYNTH_FLOW + "/%s" + TRAIN + "/%s" + GENERATED_DATA
MANAGEMENT_GET_GENERATED_DATA_CSV = SINGLE_PROJECT_URL + SYNTH_FLOW + "/%s" + TRAIN + "/%s" + GENERATED_DATA_CSV + "/%s"
MANAGEMENT_GET_SAMPLE_CSV = SINGLE_PROJECT_URL + SYNTH_FLOW + "/%s" + SAMPLE_DATA_CSV + "/%s"
MANAGEMENT_PUT_SYNTH_FLOW = SINGLE_PROJECT_URL + SYNTH_FLOW + "/%s" + SYNTHESIZE
