# AUTOGENERATED! DO NOT EDIT! File to edit: 04_mapper.ipynb (unless otherwise specified).

__all__ = ['PreviewsMapping']

# Cell
import pandas as pd
from datetime import datetime
from .models.fixture import *
from typing import Dict

# Cell
class PreviewsMapping:
    """
    A class to represent a data mapper from a mongo database.

    ...

    Methods
    -------
    get_team_id(team_name, df_teams)
        returns the "opta" ID of a given team.
    get_game_id_date(home_team_id, away_team_id, preview_date)
        returns the id and the date of a given game.
    """

    @staticmethod
    def get_team_id(team_name: str, df_teams: pd.DataFrame) -> int:
        """
          returns the "opta" ID of a given team.

        Parameters
        ----------
        team_name: str
            the name of a given team
        df_teams: pd.DataFrame
            a dataframe that contains teams and their different names

        Returns
        -------
        int

        """
        # The name of a given team
        # Filter the dictionary
        # If the given team name exists in the dataframe
        # We return its optaID
        # Else we return -1
        if team_name != None:

            team_name = team_name.strip().lower()
            df_filtred = df_teams[
                (df_teams["name"].str.lower() == team_name)
                | (df_teams["shortClubName"].str.lower() == team_name)
                | (df_teams["optaName"].str.lower() == team_name)
                | (df_teams["whoScoredName"].str.lower() == team_name)
                | (df_teams["sofifaName"].str.lower() == team_name)
                | (df_teams["statsName"].str.lower() == team_name)
                | (df_teams["inStatName"].str.lower() == team_name)
                | (df_teams["transfermarktName"].str.lower() == team_name)
                | (df_teams["fotmobName"].str.lower() == team_name)
                | (df_teams["oddsportalName"].str.lower() == team_name)
                | (df_teams["fminsideName"].str.lower() == team_name)
                | (df_teams["nickName1"].str.lower() == team_name)
                | (df_teams["nickName2"].str.lower() == team_name)
                | (df_teams["nickName3"].str.lower() == team_name)
            ]

            if len(df_filtred) > 0:
                return df_filtred["optaId"][df_filtred.index[0]]

        return -1

    @staticmethod
    def get_game_id_date(
        home_team_id: str, away_team_id: str, preview_date: datetime
    ) -> Fixture:
        """
          returns the id and the date of a given game.

        Parameters
        ----------
        home_team_id: str
            the opta id of a home team.
        away_team_id: str
            the opta id of an away team.
        preview_date: datetime
            the preview date

        Returns
        -------
        Fixture class

        """

        # Do a MongoDb query
        # Filter data by gameDate,competitionId,
        # homeTeamId, awayTeamId
        game = Fixture.objects(
            gameDate__gte=preview_date,
            homeTeamId=int(home_team_id),
            awayTeamId=int(away_team_id),
        ).first()

        # if the game is a Premier League
        # and the preview date is less than 15 days from the match date
        # we return the game
        if game != None:
            date_interval = game.gameDate - preview_date.replace(tzinfo=None)
            if (game.competitionId == 8) and (date_interval.days <= 15):
                return game

        return None