# AUTOGENERATED! DO NOT EDIT! File to edit: 001_mongo.ipynb (unless otherwise specified).

__all__ = ['db_connect', 'mongo_init']

# Cell
from typing import Optional

import mongoengine

from .localconfig import CONFIG, DB_HOSTS


def db_connect(db_host: str, db_name: str, db_alias: Optional[str] = None):
    """Connect to the apprpriate mongo database

    The function will form the appropriate uri-string and then pass it to `mongoengine.resgister_connection()`

    Parameters
    ----------
    db_host : str
        Host name as defined in `DB_HOSTS`
    db_name: str
        Name of the database to connect to
    db_alias: str, optional
        alias of the database we are connecting to. If not provided, we will use `db_name`

    """
    # check that the host name provided is valid
    if db_host not in DB_HOSTS:
        raise ValueError(
            "db-host provided {db_host} should be one of {hosts}:".format(
                db_host=db_host, hosts=DB_HOSTS
            )
        )

    # decide on the alias to apply
    db_alias = db_name if not db_name else db_alias

    # read config for the appropriate database
    db_config = CONFIG["databases"][db_host]

    # form the mongo-url i.e check if we need the port
    db_url = (
        db_config["url"]
        if not db_config["port"]
        else db_config["url"] + ":" + db_config["port"]
    )

    db_uri = "{base_url}{user}:{password}@{url}/{db}".format(
        base_url=db_config["mongo_base"],
        user=db_config["user"],
        password=db_config["password"],
        url=db_url,
        db=db_name,
    )
    # add optional argument
    optional_uri = []
    if db_config["majority"]:
        optional_uri.append("w={majority}".format(majority="majority"))
    if db_config["retry_writes"]:
        optional_uri.append(
            "retryWrites={majority}".format(
                majority=str(db_config["retry_writes"]).lower()
            )
        )
    if db_config["authSource"]:
        optional_uri.append(
            "authSource={auth_db}".format(auth_db=db_config["authSource"])
        )

    if optional_uri:
        db_uri += "?" + "&".join(optional_uri)

    mongoengine.register_connection(host=db_uri, alias=db_alias, name=db_name)

# Cell


def mongo_init(db_host: str):
    """
    Register all the required mongo connections

    Parameters
    ----------
    db_host : str
        Host name as defined in `DB_HOSTS`

    """
    # check that the host name provided is valid
    if db_host not in DB_HOSTS:
        raise ValueError(
            "db-host provided {db_host} should be one of {hosts}:".format(
                db_host=db_host, hosts=DB_HOSTS
            )
        )

    ## opta db
    db_connect(
        db_host=db_host,
        db_name=CONFIG["connections"]["opta"]["db"],
        db_alias="opta",
    )

    ## theguardian db
    db_connect(
        db_host=db_host,
        db_name=CONFIG["connections"]["theguardian"]["db"],
        db_alias="theguardian",
    )