# AUTOGENERATED! DO NOT EDIT! File to edit: 03_Db_Config.ipynb (unless otherwise specified).

__all__ = ['MongoClient']

# Cell
import pymongo
import mongoengine
import json
import logging
from mongoengine import connect,disconnect

# Cell
class MongoClient:
    """
    A class to represent a MongoDb client.

    ...

    Attributes
    ----------
    CREDENTIALS_PATH : str
        the file path of the MongoDb credentials

    Methods
    -------
    find_credentials()
        returns MongoDb credentials stored in a local file.
    connect(index)
        returns the mongoDb instance.
    save(collection)
        save the MongoDb collection.

    """

    # the file path of the MongoDb credentials
    CREDENTIALS_PATH = "//home//meherkh//secrets//credentials.json"

    @staticmethod
    def find_credentials() -> dict:
        """
          returns MongoDb credentials stored in a local file.

        Returns
        -------
        dict

        """
        # open file and extract the json fields
        try:
            with open(MongoClient.CREDENTIALS_PATH) as credentials:
                mongo_credentials = json.load(credentials)
                return mongo_credentials
        except EnvironmentError:
            logging.error("Could not open the credentials file")

    @staticmethod
    def connect(index: str) -> pymongo.mongo_client.MongoClient:
        """
          returns the mongoDb instance.

        Parameters
        ----------
        index: str
            the index of the cluster

        Returns
        -------
        pymongo.mongo_client.MongoClient

        """
        # Initialize a MongoDb instance with mongoengine
        try:
            disconnect()
            DB_URI = MongoClient.find_credentials()["DB_URI"][index]
            mongoengine_client = connect(host=DB_URI)
            return mongoengine_client
        except Exception as e:
            logging.error("Could not connect to the database")

    @staticmethod
    def save(
        collection: mongoengine.base.metaclasses.TopLevelDocumentMetaclass,
    ) -> None:
        """
          save the MongoDb collection.

        Parameters
        ----------
        collection: mongoengine.base.metaclasses.TopLevelDocumentMetaclass
            the MongoDb collection

        Returns
        -------
        None

        """
        try:
            collection.validate()
            collection.save()
        except Exception as e:
            logging.error("The input data does not match the class criteria.")