# -*- coding: utf-8 -*-
# Generated by Django 1.11.4 on 2017-09-24 10:03
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import i18nfield.fields


class Migration(migrations.Migration):

    dependencies = [
        ('submission', '0006_auto_20170913_1142'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='submission',
            name='accept_feedback',
        ),
        migrations.AlterField(
            model_name='cfp',
            name='deadline',
            field=models.DateTimeField(blank=True, help_text='Please put in the last date you want to accept submissions from users.', null=True, verbose_name='deadline'),
        ),
        migrations.AlterField(
            model_name='cfp',
            name='default_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to='submission.SubmissionType', verbose_name='Default submission type'),
        ),
        migrations.AlterField(
            model_name='cfp',
            name='headline',
            field=i18nfield.fields.I18nCharField(blank=True, max_length=300, null=True, verbose_name='headline'),
        ),
        migrations.AlterField(
            model_name='cfp',
            name='text',
            field=i18nfield.fields.I18nTextField(blank=True, help_text='You can use markdown here.', null=True, verbose_name='text'),
        ),
        migrations.AlterField(
            model_name='feedback',
            name='review',
            field=models.TextField(help_text='You can use markdown here.', verbose_name='Review'),
        ),
        migrations.AlterField(
            model_name='question',
            name='default_answer',
            field=models.TextField(blank=True, null=True, verbose_name='default answer'),
        ),
        migrations.AlterField(
            model_name='question',
            name='position',
            field=models.IntegerField(default=0, verbose_name='position'),
        ),
        migrations.AlterField(
            model_name='question',
            name='question',
            field=i18nfield.fields.I18nCharField(max_length=200, verbose_name='question'),
        ),
        migrations.AlterField(
            model_name='question',
            name='required',
            field=models.BooleanField(default=False, verbose_name='required'),
        ),
        migrations.AlterField(
            model_name='submission',
            name='duration',
            field=models.PositiveIntegerField(blank=True, help_text='The duration in minutes. Leave empty for default duration for this submission type.', null=True, verbose_name='Duration'),
        ),
        migrations.AlterField(
            model_name='submission',
            name='state',
            field=models.CharField(choices=[('submitted', 'submitted'), ('rejected', 'rejected'), ('accepted', 'accepted'), ('confirmed', 'confirmed'), ('canceled', 'canceled'), ('withdrawn', 'withdrawn'), ('deleted', 'deleted')], default='submitted', max_length=9, verbose_name='Submission state'),
        ),
        migrations.AlterField(
            model_name='submissiontype',
            name='default_duration',
            field=models.PositiveIntegerField(default=30, help_text='Default duration in minutes', verbose_name='default duration'),
        ),
        migrations.AlterField(
            model_name='submissiontype',
            name='max_duration',
            field=models.PositiveIntegerField(default=60, help_text='Maximum duration in minutes', verbose_name='maximum duration'),
        ),
        migrations.AlterField(
            model_name='submissiontype',
            name='name',
            field=i18nfield.fields.I18nCharField(max_length=100, verbose_name='name'),
        ),
    ]
