/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.session;

import org.drools.core.SessionConfiguration;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.session.AbstractKieSessionsPool;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.kiesession.session.StatefulSessionPool;
import org.drools.kiesession.session.StatelessKnowledgeSessionImpl;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;

public class KieSessionsPoolImpl
extends AbstractKieSessionsPool {
    private final InternalKnowledgeBase kBase;

    public KieSessionsPoolImpl(InternalKnowledgeBase kBase, int initialSize) {
        super(initialSize);
        this.kBase = kBase;
    }

    @Override
    public KieSession newKieSession() {
        return this.newKieSession(this.kBase.getSessionConfiguration());
    }

    @Override
    public KieSession newKieSession(KieSessionConfiguration conf) {
        return this.getPool(conf, false).get();
    }

    @Override
    public StatelessKieSession newStatelessKieSession() {
        return this.newStatelessKieSession(this.kBase.getSessionConfiguration());
    }

    @Override
    public StatelessKieSession newStatelessKieSession(KieSessionConfiguration conf) {
        return new StatelessKnowledgeSessionImpl(conf, this.getPool(conf, true));
    }

    @Override
    protected String getKey(String kSessionName, KieSessionConfiguration conf, boolean stateless) {
        String key = stateless ? "DEFAULT_STATELESS" : "DEFAULT";
        return conf == null ? key : key + "@" + System.identityHashCode(conf);
    }

    @Override
    protected StatefulSessionPool createStatefulSessionPool(String kSessionName, KieSessionConfiguration conf, boolean stateless) {
        return new StatefulSessionPool(this.kBase, this.initialSize, () -> stateless ? ((StatefulKnowledgeSessionImpl)RuntimeComponentFactory.get().createStatefulSession(this.kBase, this.environment, (SessionConfiguration)conf, true)).setStateless(true) : (StatefulKnowledgeSessionImpl)this.kBase.newKieSession(conf, this.environment, true));
    }
}

