/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NetworkNode;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.AsyncReceiveNode;
import org.drools.core.reteoo.AsyncSendNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.ConditionalBranchNode;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.ExistsNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.RiaPathMemory;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.TimerNode;
import org.drools.core.rule.constraint.QueryNameConstraint;

public class SegmentUtilities {
    private static final int NOT_NODE_BIT = 1;
    private static final int JOIN_NODE_BIT = 2;
    private static final int REACTIVE_EXISTS_NODE_BIT = 4;
    private static final int PASSIVE_EXISTS_NODE_BIT = 8;

    public static SegmentMemory getOrCreateSegmentMemory(LeftTupleSource tupleSource, ReteEvaluator reteEvaluator) {
        long allLinkedTestMask;
        int nodeTypesInSegment;
        LeftTupleSource segmentRoot;
        SegmentMemory smem;
        block25: {
            block24: {
                LeftTupleSinkNode sink;
                smem = reteEvaluator.getNodeMemory((MemoryFactory)((Object)tupleSource)).getSegmentMemory();
                if (smem != null) {
                    return smem;
                }
                while (!SegmentUtilities.isRootNode(tupleSource, null)) {
                    tupleSource = tupleSource.getLeftTupleSource();
                }
                segmentRoot = tupleSource;
                nodeTypesInSegment = 0;
                smem = SegmentUtilities.restoreSegmentFromPrototype(reteEvaluator, segmentRoot, nodeTypesInSegment);
                if (smem != null) {
                    if (NodeTypeEnums.isBetaNode(segmentRoot) && ((BetaNode)segmentRoot).isRightInputIsRiaNode()) {
                        SegmentUtilities.createRiaSegmentMemory((BetaNode)segmentRoot, reteEvaluator);
                    }
                    return smem;
                }
                smem = new SegmentMemory(segmentRoot);
                long nodePosMask = 1L;
                allLinkedTestMask = 0L;
                boolean updateNodeBit = true;
                while (true) {
                    nodeTypesInSegment = SegmentUtilities.updateNodeTypesMask(tupleSource, nodeTypesInSegment);
                    if (NodeTypeEnums.isBetaNode(tupleSource)) {
                        allLinkedTestMask = SegmentUtilities.processBetaNode((BetaNode)tupleSource, reteEvaluator, smem, nodePosMask, allLinkedTestMask, updateNodeBit);
                    } else {
                        switch (tupleSource.getType()) {
                            case 120: {
                                allLinkedTestMask = SegmentUtilities.processLiaNode((LeftInputAdapterNode)tupleSource, reteEvaluator, smem, nodePosMask, allLinkedTestMask);
                                break;
                            }
                            case 131: {
                                SegmentUtilities.processEvalNode((EvalConditionNode)tupleSource, reteEvaluator, smem);
                                break;
                            }
                            case 167: {
                                updateNodeBit = SegmentUtilities.processBranchNode((ConditionalBranchNode)tupleSource, reteEvaluator, smem);
                                break;
                            }
                            case 151: {
                                SegmentUtilities.processFromNode((FromNode)tupleSource, reteEvaluator, smem);
                                break;
                            }
                            case 153: {
                                SegmentUtilities.processReactiveFromNode((MemoryFactory)((Object)tupleSource), reteEvaluator, smem, nodePosMask);
                                break;
                            }
                            case 133: {
                                SegmentUtilities.processTimerNode((TimerNode)tupleSource, reteEvaluator, smem, nodePosMask);
                                break;
                            }
                            case 135: {
                                SegmentUtilities.processAsyncSendNode((AsyncSendNode)tupleSource, reteEvaluator, smem);
                                break;
                            }
                            case 137: {
                                SegmentUtilities.processAsyncReceiveNode((AsyncReceiveNode)tupleSource, reteEvaluator, smem, nodePosMask);
                                break;
                            }
                            case 165: {
                                updateNodeBit = SegmentUtilities.processQueryNode((QueryElementNode)tupleSource, reteEvaluator, segmentRoot, smem, nodePosMask);
                            }
                        }
                    }
                    nodePosMask = SegmentUtilities.nextNodePosMask(nodePosMask);
                    if (tupleSource.getSinkPropagator().size() != 1) break block24;
                    sink = tupleSource.getSinkPropagator().getFirstLeftTupleSink();
                    if (!NodeTypeEnums.isLeftTupleSource(sink)) break;
                    tupleSource = (LeftTupleSource)((Object)sink);
                }
                Object memory = reteEvaluator.getNodeMemory((MemoryFactory)((Object)sink));
                if (sink.getType() == 71) {
                    ObjectSink[] nodes;
                    RiaPathMemory riaPmem = ((RightInputAdapterNode.RiaNodeMemory)memory).getRiaPathMemory();
                    smem.getNodeMemories().add(riaPmem);
                    RightInputAdapterNode rian = (RightInputAdapterNode)sink;
                    for (ObjectSink node : nodes = rian.getObjectSinkPropagator().getSinks()) {
                        if (!NodeTypeEnums.isLeftTupleSource(node)) continue;
                        SegmentUtilities.getOrCreateSegmentMemory((LeftTupleSource)((Object)node), reteEvaluator);
                    }
                } else if (NodeTypeEnums.isTerminalNode(sink)) {
                    smem.getNodeMemories().add((Memory)memory);
                }
                memory.setSegmentMemory(smem);
                smem.setTipNode(sink);
                break block25;
            }
            smem.setTipNode(tupleSource);
        }
        smem.setAllLinkedMaskTest(allLinkedTestMask);
        LeftTupleSource pathRoot = segmentRoot;
        int ruleSegmentPosMask = 1;
        int counter = 0;
        while (pathRoot.getType() != 120) {
            LeftTupleSource leftTupleSource = pathRoot.getLeftTupleSource();
            if (SegmentUtilities.isNonTerminalTipNode(leftTupleSource, null)) {
                ruleSegmentPosMask <<= 1;
                ++counter;
            }
            pathRoot = leftTupleSource;
        }
        smem.setSegmentPosMaskBit(ruleSegmentPosMask);
        smem.setPos(counter);
        SegmentUtilities.updateRiaAndTerminalMemory(tupleSource, tupleSource, smem, reteEvaluator, false, nodeTypesInSegment);
        reteEvaluator.getKnowledgeBase().registerSegmentPrototype(segmentRoot, smem);
        return smem;
    }

    public static long nextNodePosMask(long nodePosMask) {
        long nextNodePosMask = nodePosMask << 1;
        return nextNodePosMask > 0L ? nextNodePosMask : nodePosMask;
    }

    private static SegmentMemory restoreSegmentFromPrototype(ReteEvaluator reteEvaluator, LeftTupleSource segmentRoot, int nodeTypesInSegment) {
        SegmentMemory smem = reteEvaluator.getKnowledgeBase().createSegmentFromPrototype(reteEvaluator, segmentRoot);
        if (smem != null) {
            SegmentUtilities.updateRiaAndTerminalMemory(segmentRoot, segmentRoot, smem, reteEvaluator, true, nodeTypesInSegment);
        }
        return smem;
    }

    private static boolean processQueryNode(QueryElementNode queryNode, ReteEvaluator reteEvaluator, LeftTupleSource segmentRoot, SegmentMemory smem, long nodePosMask) {
        SegmentMemory querySmem = SegmentUtilities.getQuerySegmentMemory(reteEvaluator, segmentRoot, queryNode);
        QueryElementNode.QueryElementNodeMemory queryNodeMem = smem.createNodeMemory(queryNode, reteEvaluator);
        queryNodeMem.setNodePosMaskBit(nodePosMask);
        queryNodeMem.setQuerySegmentMemory(querySmem);
        queryNodeMem.setSegmentMemory(smem);
        return !queryNode.getQueryElement().isAbductive();
    }

    public static SegmentMemory getQuerySegmentMemory(ReteEvaluator reteEvaluator, LeftTupleSource segmentRoot, QueryElementNode queryNode) {
        LeftInputAdapterNode liaNode = SegmentUtilities.getQueryLiaNode(queryNode.getQueryElement().getQueryName(), SegmentUtilities.getQueryOtn(segmentRoot));
        LeftInputAdapterNode.LiaNodeMemory liam = reteEvaluator.getNodeMemory(liaNode);
        SegmentMemory querySmem = liam.getSegmentMemory();
        if (querySmem == null) {
            querySmem = SegmentUtilities.getOrCreateSegmentMemory(liaNode, reteEvaluator);
        }
        return querySmem;
    }

    private static void processFromNode(MemoryFactory tupleSource, ReteEvaluator reteEvaluator, SegmentMemory smem) {
        smem.createNodeMemory(tupleSource, reteEvaluator).setSegmentMemory(smem);
    }

    private static void processAsyncSendNode(MemoryFactory tupleSource, ReteEvaluator reteEvaluator, SegmentMemory smem) {
        smem.createNodeMemory(tupleSource, reteEvaluator).setSegmentMemory(smem);
    }

    private static void processAsyncReceiveNode(AsyncReceiveNode tupleSource, ReteEvaluator reteEvaluator, SegmentMemory smem, long nodePosMask) {
        AsyncReceiveNode.AsyncReceiveMemory tnMem = smem.createNodeMemory(tupleSource, reteEvaluator);
        tnMem.setNodePosMaskBit(nodePosMask);
        tnMem.setSegmentMemory(smem);
    }

    private static void processReactiveFromNode(MemoryFactory tupleSource, ReteEvaluator reteEvaluator, SegmentMemory smem, long nodePosMask) {
        FromNode.FromMemory mem = (FromNode.FromMemory)smem.createNodeMemory(tupleSource, reteEvaluator);
        mem.setSegmentMemory(smem);
        mem.setNodePosMaskBit(nodePosMask);
    }

    private static boolean processBranchNode(ConditionalBranchNode tupleSource, ReteEvaluator reteEvaluator, SegmentMemory smem) {
        ConditionalBranchNode.ConditionalBranchMemory branchMem = smem.createNodeMemory(tupleSource, reteEvaluator);
        branchMem.setSegmentMemory(smem);
        return false;
    }

    private static void processEvalNode(EvalConditionNode tupleSource, ReteEvaluator reteEvaluator, SegmentMemory smem) {
        EvalConditionNode.EvalMemory evalMem = smem.createNodeMemory(tupleSource, reteEvaluator);
        evalMem.setSegmentMemory(smem);
    }

    private static void processTimerNode(TimerNode tupleSource, ReteEvaluator reteEvaluator, SegmentMemory smem, long nodePosMask) {
        TimerNode.TimerNodeMemory tnMem = smem.createNodeMemory(tupleSource, reteEvaluator);
        tnMem.setNodePosMaskBit(nodePosMask);
        tnMem.setSegmentMemory(smem);
    }

    private static long processLiaNode(LeftInputAdapterNode tupleSource, ReteEvaluator reteEvaluator, SegmentMemory smem, long nodePosMask, long allLinkedTestMask) {
        LeftInputAdapterNode.LiaNodeMemory liaMemory = smem.createNodeMemory(tupleSource, reteEvaluator);
        liaMemory.setSegmentMemory(smem);
        liaMemory.setNodePosMaskBit(nodePosMask);
        return allLinkedTestMask |= nodePosMask;
    }

    private static long processBetaNode(BetaNode betaNode, ReteEvaluator reteEvaluator, SegmentMemory smem, long nodePosMask, long allLinkedTestMask, boolean updateNodeBit) {
        BetaMemory bm = 211 == betaNode.getType() ? ((AccumulateNode.AccumulateMemory)smem.createNodeMemory(betaNode, reteEvaluator)).getBetaMemory() : (BetaMemory)smem.createNodeMemory(betaNode, reteEvaluator);
        bm.setSegmentMemory(smem);
        if (betaNode.isRightInputIsRiaNode()) {
            RightInputAdapterNode riaNode = SegmentUtilities.createRiaSegmentMemory(betaNode, reteEvaluator);
            RightInputAdapterNode.RiaNodeMemory riaMem = reteEvaluator.getNodeMemory(riaNode);
            bm.setRiaRuleMemory(riaMem.getRiaPathMemory());
            if (updateNodeBit && SegmentUtilities.canBeDisabled(betaNode) && riaMem.getRiaPathMemory().getAllLinkedMaskTest() > 0L) {
                allLinkedTestMask |= nodePosMask;
            }
        } else if (updateNodeBit && SegmentUtilities.canBeDisabled(betaNode)) {
            allLinkedTestMask |= nodePosMask;
        }
        bm.setNodePosMaskBit(nodePosMask);
        if (191 == betaNode.getType()) {
            smem.linkNodeWithoutRuleNotify(bm.getNodePosMaskBit());
        }
        return allLinkedTestMask;
    }

    private static RightInputAdapterNode createRiaSegmentMemory(BetaNode betaNode, ReteEvaluator reteEvaluator) {
        RightInputAdapterNode riaNode = (RightInputAdapterNode)betaNode.getRightInput();
        LeftTupleSource subnetworkLts = riaNode.getLeftTupleSource();
        while (subnetworkLts.getLeftTupleSource() != riaNode.getStartTupleSource()) {
            subnetworkLts = subnetworkLts.getLeftTupleSource();
        }
        Object rootSubNetwokrMem = reteEvaluator.getNodeMemory((MemoryFactory)((Object)subnetworkLts));
        SegmentMemory subNetworkSegmentMemory = rootSubNetwokrMem.getSegmentMemory();
        if (subNetworkSegmentMemory == null) {
            SegmentUtilities.getOrCreateSegmentMemory(subnetworkLts, reteEvaluator);
        }
        return riaNode;
    }

    private static boolean canBeDisabled(BetaNode betaNode) {
        return (191 != betaNode.getType() || ((NotNode)betaNode).isEmptyBetaConstraints()) && 211 != betaNode.getType() && !betaNode.isRightInputPassive();
    }

    public static void createChildSegments(ReteEvaluator reteEvaluator, SegmentMemory smem, LeftTupleSinkPropagator sinkProp) {
        if (!smem.isEmpty()) {
            return;
        }
        for (LeftTupleSinkNode sink = sinkProp.getFirstLeftTupleSink(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            SegmentMemory childSmem = SegmentUtilities.createChildSegment(reteEvaluator, sink);
            childSmem.setPos(smem.getPos() + 1);
            smem.add(childSmem);
        }
    }

    public static SegmentMemory createChildSegment(ReteEvaluator reteEvaluator, LeftTupleNode node) {
        Object memory = reteEvaluator.getNodeMemory((MemoryFactory)((Object)node));
        if (memory.getSegmentMemory() == null) {
            if (NodeTypeEnums.isEndNode(node)) {
                SegmentUtilities.createChildSegmentForTerminalNode(node, memory);
            } else {
                SegmentUtilities.getOrCreateSegmentMemory((LeftTupleSource)node, reteEvaluator);
            }
        }
        return memory.getSegmentMemory();
    }

    public static SegmentMemory createChildSegmentForTerminalNode(LeftTupleNode node, Memory memory) {
        SegmentMemory childSmem = new SegmentMemory(node);
        PathMemory pmem = NodeTypeEnums.isTerminalNode(node) ? (PathMemory)memory : ((RightInputAdapterNode.RiaNodeMemory)memory).getRiaPathMemory();
        childSmem.setPos(pmem.getSegmentMemories().length - 1);
        pmem.setSegmentMemory(childSmem.getPos(), childSmem);
        pmem.setSegmentMemory(childSmem);
        childSmem.addPathMemory(pmem);
        childSmem.setTipNode(node);
        return childSmem;
    }

    public static boolean inSubNetwork(RightInputAdapterNode riaNode, LeftTupleSource leftTupleSource) {
        LeftTupleSource startTupleSource = riaNode.getStartTupleSource();
        for (LeftTupleSource parent = riaNode.getLeftTupleSource(); parent != startTupleSource; parent = parent.getLeftTupleSource()) {
            if (parent != leftTupleSource) continue;
            return true;
        }
        return false;
    }

    private static int updateRiaAndTerminalMemory(LeftTupleSource lt, LeftTupleSource originalLt, SegmentMemory smem, ReteEvaluator reteEvaluator, boolean fromPrototype, int nodeTypesInSegment) {
        nodeTypesInSegment = SegmentUtilities.checkSegmentBoundary(lt, reteEvaluator, nodeTypesInSegment);
        PathMemory pmem = null;
        for (LeftTupleSink sink : lt.getSinkPropagator().getSinks()) {
            if (NodeTypeEnums.isLeftTupleSource(sink)) {
                nodeTypesInSegment = SegmentUtilities.updateRiaAndTerminalMemory((LeftTupleSource)((Object)sink), originalLt, smem, reteEvaluator, fromPrototype, nodeTypesInSegment);
            } else if (sink.getType() == 71) {
                RightInputAdapterNode.RiaNodeMemory riaMem = (RightInputAdapterNode.RiaNodeMemory)reteEvaluator.getNodeMemory((MemoryFactory)((Object)sink));
                if (SegmentUtilities.inSubNetwork((RightInputAdapterNode)sink, originalLt)) {
                    ObjectSink[] nodes;
                    pmem = riaMem.getRiaPathMemory();
                    if (fromPrototype) {
                        for (ObjectSink node : nodes = ((RightInputAdapterNode)sink).getObjectSinkPropagator().getSinks()) {
                            if (!NodeTypeEnums.isLeftTupleSource(node) || reteEvaluator.getNodeMemory((MemoryFactory)((Object)node)).getSegmentMemory() != null) continue;
                            SegmentUtilities.restoreSegmentFromPrototype(reteEvaluator, (LeftTupleSource)((Object)node), nodeTypesInSegment);
                        }
                    } else if ((pmem.getAllLinkedMaskTest() & 1L << pmem.getSegmentMemories().length) == 0L) {
                        for (ObjectSink node : nodes = ((RightInputAdapterNode)sink).getObjectSinkPropagator().getSinks()) {
                            if (!NodeTypeEnums.isLeftTupleSource(node)) continue;
                            SegmentUtilities.getOrCreateSegmentMemory((LeftTupleSource)((Object)node), reteEvaluator);
                        }
                    }
                }
            } else if (NodeTypeEnums.isTerminalNode(sink)) {
                pmem = (PathMemory)reteEvaluator.getNodeMemory((MemoryFactory)((Object)sink));
            }
            if (pmem == null || smem.getPos() >= pmem.getSegmentMemories().length) continue;
            smem.addPathMemory(pmem);
            pmem.setSegmentMemory(smem.getPos(), smem);
            if (smem.isSegmentLinked()) {
                smem.notifyRuleLinkSegment(reteEvaluator);
            }
            SegmentUtilities.checkEagerSegmentCreation(sink.getLeftTupleSource(), reteEvaluator, nodeTypesInSegment);
            pmem = null;
        }
        return nodeTypesInSegment;
    }

    private static int checkSegmentBoundary(LeftTupleSource lt, ReteEvaluator reteEvaluator, int nodeTypesInSegment) {
        if (SegmentUtilities.isRootNode(lt, null)) {
            SegmentUtilities.checkEagerSegmentCreation(lt.getLeftTupleSource(), reteEvaluator, nodeTypesInSegment);
            nodeTypesInSegment = 0;
        }
        return SegmentUtilities.updateNodeTypesMask(lt, nodeTypesInSegment);
    }

    public static void checkEagerSegmentCreation(LeftTupleSource lt, ReteEvaluator reteEvaluator, int nodeTypesInSegment) {
        if (SegmentUtilities.isSet(nodeTypesInSegment, 1) && !SegmentUtilities.isSet(nodeTypesInSegment, 2) && !SegmentUtilities.isSet(nodeTypesInSegment, 4)) {
            SegmentUtilities.getOrCreateSegmentMemory(lt, reteEvaluator);
        }
    }

    public static boolean isRootNode(LeftTupleNode node, TerminalNode removingTN) {
        return node.getType() == 120 || SegmentUtilities.isNonTerminalTipNode(node.getLeftTupleSource(), removingTN);
    }

    public static boolean isTipNode(LeftTupleNode node, TerminalNode removingTN) {
        return NodeTypeEnums.isEndNode(node) || SegmentUtilities.isNonTerminalTipNode(node, removingTN);
    }

    public static boolean isNonTerminalTipNode(LeftTupleNode node, TerminalNode removingTN) {
        LeftTupleSinkPropagator sinkPropagator = node.getSinkPropagator();
        if (removingTN == null) {
            return sinkPropagator.size() > 1;
        }
        if (sinkPropagator.size() == 1) {
            return false;
        }
        int count = 0;
        for (LeftTupleSinkNode sink = sinkPropagator.getFirstLeftTupleSink(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            if (!SegmentUtilities.sinkNotExclusivelyAssociatedWithTerminal(removingTN, sink) || ++count <= 1) continue;
            return true;
        }
        return false;
    }

    private static boolean sinkNotExclusivelyAssociatedWithTerminal(TerminalNode removingTN, LeftTupleSinkNode sink) {
        return sink.getAssociationsSize() > 1 || !sink.isAssociatedWith(removingTN.getRule()) || !removingTN.isTerminalNodeOf(sink) || SegmentUtilities.hasTerminalNodesDifferentThan(sink, removingTN);
    }

    private static boolean hasTerminalNodesDifferentThan(LeftTupleSinkNode node, TerminalNode tn) {
        LeftTupleSinkPropagator sinkPropagator = node.getSinkPropagator();
        for (LeftTupleSinkNode sink = sinkPropagator.getFirstLeftTupleSink(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            if (!(sink instanceof TerminalNode ? tn.getId() != sink.getId() : SegmentUtilities.hasTerminalNodesDifferentThan(sink, tn))) continue;
            return true;
        }
        return false;
    }

    private static ObjectTypeNode getQueryOtn(LeftTupleSource lts) {
        while (!(lts instanceof LeftInputAdapterNode)) {
            lts = lts.getLeftTupleSource();
        }
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)lts;
        ObjectSource os = liaNode.getObjectSource();
        while (!(os instanceof EntryPointNode)) {
            os = os.getParentObjectSource();
        }
        return ((EntryPointNode)os).getQueryNode();
    }

    private static LeftInputAdapterNode getQueryLiaNode(String queryName, ObjectTypeNode queryOtn) {
        for (ObjectSink sink : queryOtn.getObjectSinkPropagator().getSinks()) {
            AlphaNode alphaNode = (AlphaNode)sink;
            QueryNameConstraint nameConstraint = (QueryNameConstraint)alphaNode.getConstraint();
            if (!queryName.equals(nameConstraint.getQueryName())) continue;
            return (LeftInputAdapterNode)alphaNode.getObjectSinkPropagator().getSinks()[0];
        }
        throw new RuntimeException("Unable to find query '" + queryName + "'");
    }

    public static int updateNodeTypesMask(NetworkNode node, int mask) {
        if (node != null) {
            switch (node.getType()) {
                case 181: {
                    mask |= 2;
                    break;
                }
                case 201: {
                    if (((ExistsNode)node).isRightInputPassive()) {
                        mask |= 8;
                        break;
                    }
                    mask |= 4;
                    break;
                }
                case 191: {
                    mask |= 1;
                }
            }
        }
        return mask;
    }

    public static boolean isSet(int mask, int bit) {
        return (mask & bit) == bit;
    }
}

