/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectConfiguration;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.kie.memorycompiler.JavaCompiler;
import org.kie.memorycompiler.JavaCompilerFactory;
import org.kie.memorycompiler.JavaConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaDialectConfiguration
extends JavaConfiguration
implements DialectConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(JavaDialectConfiguration.class);
    private static final JavaDialectConfiguration DEFAULT_JAVA_CONFIGURATION = new JavaDialectConfiguration(new KnowledgeBuilderConfigurationImpl(JavaConfiguration.class.getClassLoader()));
    private static final String DEFAULT_JAVA_VERSION = JavaDialectConfiguration.findJavaVersion(JavaDialectConfiguration.DEFAULT_JAVA_CONFIGURATION.conf.getChainedProperties().getProperty("drools.dialect.java.compiler.lnglevel", System.getProperty("java.version")));
    private KnowledgeBuilderConfigurationImpl conf;

    public JavaDialectConfiguration() {
    }

    public JavaDialectConfiguration(KnowledgeBuilderConfigurationImpl conf) {
        this.init(conf);
    }

    public static JavaConfiguration.CompilerType getDefaultCompilerType() {
        return DEFAULT_JAVA_CONFIGURATION.getCompiler();
    }

    public static void setDefaultCompilerType(JavaConfiguration.CompilerType compilerType) {
        DEFAULT_JAVA_CONFIGURATION.setCompiler(compilerType);
    }

    public static JavaCompiler createDefaultCompiler() {
        return JavaCompilerFactory.loadCompiler(DEFAULT_JAVA_CONFIGURATION.getCompiler(), DEFAULT_JAVA_VERSION, "src/main/java/");
    }

    public static JavaCompiler createNativeCompiler() {
        return JavaCompiler.createNativeCompiler(DEFAULT_JAVA_VERSION);
    }

    public static JavaCompiler createEclipseCompiler() {
        return JavaCompiler.createEclipseCompiler(DEFAULT_JAVA_VERSION);
    }

    @Override
    public void init(KnowledgeBuilderConfigurationImpl conf) {
        this.conf = conf;
        this.setCompiler(this.getDefaultCompiler());
        this.setJavaLanguageLevel(JavaDialectConfiguration.findJavaVersion(conf.getChainedProperties().getProperty("drools.dialect.java.compiler.lnglevel", System.getProperty("java.version"))));
    }

    @Override
    public KnowledgeBuilderConfigurationImpl getPackageBuilderConfiguration() {
        return this.conf;
    }

    @Override
    public Dialect newDialect(ClassLoader rootClassLoader, KnowledgeBuilderConfigurationImpl pkgConf, PackageRegistry pkgRegistry, InternalKnowledgePackage pkg) {
        return new Dialect.DummyDialect(rootClassLoader, pkgRegistry, pkg);
    }

    public boolean hasEclipseCompiler() {
        try {
            Class.forName(JavaConfiguration.CompilerType.ECLIPSE.getImplClassName(), true, this.conf.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private JavaConfiguration.CompilerType getDefaultCompiler() {
        try {
            String prop = this.conf.getChainedProperties().getProperty("drools.dialect.java.compiler", this.hasEclipseCompiler() ? "ECLIPSE" : "NATIVE");
            if (logger.isDebugEnabled()) {
                logger.debug("Selected compiler " + prop + " [drools.dialect.java.compiler:" + this.conf.getChainedProperties().getProperty("drools.dialect.java.compiler", null) + ", hasEclipseCompiler:" + this.hasEclipseCompiler() + "]");
            }
            if (prop.equalsIgnoreCase("NATIVE")) {
                return JavaConfiguration.CompilerType.NATIVE;
            }
            if (prop.equalsIgnoreCase("ECLIPSE")) {
                return JavaConfiguration.CompilerType.ECLIPSE;
            }
            logger.error("Drools config: unable to use the drools.compiler property. Using default. It was set to:" + prop);
            return JavaConfiguration.CompilerType.ECLIPSE;
        }
        catch (SecurityException e) {
            logger.error("Drools config: unable to read the drools.compiler property. Using default.", e);
            return JavaConfiguration.CompilerType.ECLIPSE;
        }
    }
}

