/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.rule.builder.EvaluatorWrapper;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.ObjectType;
import org.drools.core.facttemplates.Fact;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.util.ClassUtils;

public class BoundIdentifiers {
    private Map<String, Class<?>> declrClasses;
    private Map<String, Type> globals;
    private Map<String, EvaluatorWrapper> operators;
    private Class<?> thisClass;
    private PackageBuildContext context;

    public BoundIdentifiers(Class<?> thisClass) {
        this(Collections.EMPTY_MAP, null, (Map<String, EvaluatorWrapper>)Collections.EMPTY_MAP, thisClass);
    }

    public BoundIdentifiers(Map<String, Class<?>> declarations, PackageBuildContext context) {
        this(declarations, context, (Map<String, EvaluatorWrapper>)Collections.EMPTY_MAP, null);
    }

    public BoundIdentifiers(Map<String, Class<?>> declarations, PackageBuildContext context, Map<String, EvaluatorWrapper> operators) {
        this(declarations, context, operators, null);
    }

    public BoundIdentifiers(Pattern pattern, PackageBuildContext context, Map<String, EvaluatorWrapper> operators, ObjectType objectType) {
        this(BoundIdentifiers.getDeclarationsMap(pattern, context), context, operators, objectType.isTemplate() ? Fact.class : ((ClassObjectType)objectType).getClassType());
    }

    public BoundIdentifiers(Map<String, Class<?>> declarations, PackageBuildContext context, Map<String, EvaluatorWrapper> operators, Class<?> thisClass) {
        this.declrClasses = declarations;
        this.context = context;
        this.globals = context != null ? context.getKnowledgeBuilder().getGlobals() : Collections.EMPTY_MAP;
        this.operators = operators;
        this.thisClass = thisClass;
    }

    public PackageBuildContext getContext() {
        return this.context;
    }

    public Map<String, Class<?>> getDeclrClasses() {
        return this.declrClasses;
    }

    public Map<String, Type> getGlobals() {
        return this.globals;
    }

    public void setGlobals(Map<String, Type> globals) {
        this.globals = globals;
    }

    public Map<String, EvaluatorWrapper> getOperators() {
        return this.operators != null ? this.operators : Collections.EMPTY_MAP;
    }

    public Class<?> getThisClass() {
        return this.thisClass;
    }

    public Class<?> resolveType(String identifier) {
        Class<Object> cls = this.declrClasses.get(identifier);
        if (cls == null) {
            cls = ClassUtils.rawType(this.resolveVarType(identifier));
        }
        if (cls == null && this.operators.containsKey(identifier)) {
            cls = EvaluatorWrapper.class;
        }
        return cls;
    }

    public Type resolveVarType(String identifier) {
        return this.context == null ? null : this.context.resolveVarType(identifier);
    }

    public String toString() {
        return "thisClass: " + this.thisClass + "\ndeclarations:" + this.declrClasses + "\nglobals:" + this.globals + "\noperators:" + this.operators + "\n";
    }

    private static Map<String, Class<?>> getDeclarationsMap(Pattern pattern, PackageBuildContext context) {
        HashMap declarations = new HashMap();
        if (context instanceof RuleBuildContext) {
            RuleBuildContext ruleContext = (RuleBuildContext)context;
            for (Map.Entry<String, Declaration> entry : ruleContext.getDeclarationResolver().getDeclarations(ruleContext.getRule()).entrySet()) {
                if (entry.getValue().getExtractor() == null) continue;
                declarations.put(entry.getKey(), entry.getValue().getDeclarationClass());
            }
            if (pattern != null) {
                List<Class<?>> xpathBackReferenceClasses = pattern.getXpathBackReferenceClasses();
                for (int i = 0; i < xpathBackReferenceClasses.size(); ++i) {
                    declarations.put("$back$ref$" + i, xpathBackReferenceClasses.get(i));
                }
            }
        }
        return declarations;
    }
}

