/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.processors;

import java.util.Collection;
import org.drools.compiler.builder.impl.processors.AnnotationNormalizer;
import org.drools.compiler.builder.impl.processors.CompilationPhase;
import org.drools.drl.ast.descr.EnumDeclarationDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.TypeDeclarationDescr;
import org.drools.drl.ast.descr.TypeFieldDescr;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class TypeDeclarationAnnotationNormalizer
implements CompilationPhase {
    private final AnnotationNormalizer annotationNormalizer;
    private final PackageDescr packageDescr;

    public TypeDeclarationAnnotationNormalizer(AnnotationNormalizer annotationNormalizer, PackageDescr packageDescr) {
        this.annotationNormalizer = annotationNormalizer;
        this.packageDescr = packageDescr;
    }

    @Override
    public void process() {
        for (TypeDeclarationDescr typeDeclarationDescr : this.packageDescr.getTypeDeclarations()) {
            this.annotationNormalizer.normalize(typeDeclarationDescr);
            for (TypeFieldDescr typeFieldDescr : typeDeclarationDescr.getFields().values()) {
                this.annotationNormalizer.normalize(typeFieldDescr);
            }
        }
        for (EnumDeclarationDescr enumDeclarationDescr : this.packageDescr.getEnumDeclarations()) {
            this.annotationNormalizer.normalize(enumDeclarationDescr);
            for (TypeFieldDescr typeFieldDescr : enumDeclarationDescr.getFields().values()) {
                this.annotationNormalizer.normalize(typeFieldDescr);
            }
        }
    }

    @Override
    public Collection<? extends KnowledgeBuilderResult> getResults() {
        return this.annotationNormalizer.getResults();
    }
}

