/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.core.jpy;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.drools.ansible.rulebook.integration.api.RulesExecutor;
import org.drools.ansible.rulebook.integration.api.RulesExecutorContainer;
import org.drools.ansible.rulebook.integration.api.RulesExecutorFactory;
import org.drools.ansible.rulebook.integration.core.jpy.AstRuleMatch;
import org.json.JSONObject;
import org.kie.api.runtime.rule.Match;

public class AstRulesEngine {
    public long createRuleset(String rulesetString) {
        RulesExecutor executor = RulesExecutorFactory.createFromJson(rulesetString);
        return executor.getId();
    }

    public void dispose(long sessionId) {
        RulesExecutorContainer.INSTANCE.get(sessionId).dispose();
    }

    public String retractFact(long sessionId, String serializedFact) {
        Map<String, Object> fact = new JSONObject(serializedFact).toMap();
        Map<String, Map<String, Object>> boundFact = Map.of("m", fact);
        List<Map<String, Map>> objs = this.processMessage(serializedFact, RulesExecutorContainer.INSTANCE.get(sessionId)::processRetract);
        List results = objs.stream().map(m -> m.entrySet().stream().findFirst().map(e -> Map.of((String)e.getKey(), boundFact)).get()).collect(Collectors.toList());
        return this.toJson(results);
    }

    public String assertFact(long sessionId, String serializedFact) {
        return this.toJson(this.processMessage(serializedFact, RulesExecutorContainer.INSTANCE.get(sessionId)::processFacts));
    }

    public String assertEvent(long sessionId, String serializedFact) {
        return this.toJson(this.processMessage(serializedFact, RulesExecutorContainer.INSTANCE.get(sessionId)::processEvents));
    }

    public String getFacts(long session_id) {
        return RulesExecutorContainer.INSTANCE.get(session_id).getAllFactsAsJson();
    }

    private List<Map<String, Map>> processMessage(String serializedFact, Function<String, Collection<Match>> command) {
        return AstRuleMatch.asList(command.apply(serializedFact));
    }

    private String toJson(Object elem) {
        try {
            return RulesExecutor.OBJECT_MAPPER.writeValueAsString(elem);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

