/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain.conditions;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.drools.ansible.rulebook.integration.api.RuleGenerationContext;
import org.drools.ansible.rulebook.integration.api.rulesmodel.PrototypeFactory;
import org.drools.core.facttemplates.Event;
import org.drools.model.Condition;
import org.drools.model.DSL;
import org.drools.model.Drools;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.PrototypeDSL;
import org.drools.model.PrototypeExpression;
import org.drools.model.PrototypeFact;
import org.drools.model.PrototypeVariable;
import org.drools.model.Rule;
import org.drools.model.view.CombinedExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.drools.modelcompiler.facttemplate.FactFactory;

public class OnceWithinDefinition {
    private final int amount;
    private final TimeUnit timeUnit;
    private final List<String> uniqueAttributes;
    PrototypeDSL.PrototypePatternDef guardedPattern;

    public OnceWithinDefinition(int amount, TimeUnit timeUnit, List<String> uniqueAttributes) {
        this.amount = amount;
        this.timeUnit = timeUnit;
        this.uniqueAttributes = uniqueAttributes;
    }

    public PrototypeVariable getGuardedVariable() {
        return (PrototypeVariable)this.guardedPattern.getFirstVariable();
    }

    public ViewItem appendGuardPattern(RuleGenerationContext ruleContext, ViewItem pattern) {
        this.guardedPattern = (PrototypeDSL.PrototypePatternDef)pattern;
        return new CombinedExprViewItem(Condition.Type.AND, new ViewItem[]{this.guardedPattern, DSL.not(this.createControlPattern(ruleContext), new ViewItemBuilder[0])});
    }

    private PrototypeDSL.PrototypePatternDef createControlPattern(RuleGenerationContext ruleContext) {
        PrototypeDSL.PrototypePatternDef controlPattern = PrototypeDSL.protoPattern(PrototypeDSL.variable(PrototypeFactory.getPrototype("DROOLS_SYNTHETIC_PROTOTYPE")));
        for (String unique : this.uniqueAttributes) {
            controlPattern.expr(PrototypeExpression.prototypeField(unique), Index.ConstraintType.EQUAL, this.getGuardedVariable(), PrototypeExpression.prototypeField(unique));
        }
        return controlPattern;
    }

    public BiConsumer<Drools, PrototypeFact> insertGuardConsequence(RuleGenerationContext ruleContext) {
        return (drools, fact) -> {
            Event controlEvent = FactFactory.createMapBasedEvent(PrototypeFactory.getPrototype("DROOLS_SYNTHETIC_PROTOTYPE")).withExpiration(this.amount, this.timeUnit);
            for (String unique : this.uniqueAttributes) {
                controlEvent.set(unique, fact.get(unique));
            }
            drools.insert(controlEvent);
        };
    }

    public Rule cleanupRule(RuleGenerationContext ruleContext) {
        return PatternDSL.rule("cleanup_" + UUID.randomUUID()).metadata("SYNTHETIC_RULE", true).build(this.guardedPattern, this.createControlPattern(ruleContext), DSL.on(this.getGuardedVariable()).execute((drools, fact) -> drools.delete(fact)));
    }

    public String toString() {
        return "OnceWithinDefinition{value=" + this.amount + ", timeUnit=" + this.timeUnit + ", uniqueAttributes=" + this.uniqueAttributes + "}";
    }

    static OnceWithinDefinition parseOnceWithin(String onceWithin, List<String> uniqueAttributes) {
        int sepPos = onceWithin.indexOf(32);
        if (sepPos <= 0) {
            throw new IllegalArgumentException("Invalid once_within definition: " + onceWithin);
        }
        int value = Integer.parseInt(onceWithin.substring(0, sepPos).trim());
        TimeUnit timeUnit = OnceWithinDefinition.parseTimeUnit(onceWithin.substring(sepPos + 1).trim());
        List<String> sanitizedAttributes = uniqueAttributes.stream().map(OnceWithinDefinition::sanitizeAttributeName).collect(Collectors.toList());
        return new OnceWithinDefinition(value, timeUnit, sanitizedAttributes);
    }

    private static String sanitizeAttributeName(String name) {
        if (name.startsWith("event.")) {
            return name.substring("event.".length());
        }
        if (name.startsWith("events.")) {
            return name.substring("events.".length());
        }
        if (name.startsWith("fact.")) {
            return name.substring("fact.".length());
        }
        if (name.startsWith("facts.")) {
            return name.substring("facts.".length());
        }
        return name;
    }

    private static TimeUnit parseTimeUnit(String unit) {
        if (unit.equalsIgnoreCase("millisecond") || unit.equalsIgnoreCase("milliseconds")) {
            return TimeUnit.MILLISECONDS;
        }
        if (unit.equalsIgnoreCase("second") || unit.equalsIgnoreCase("seconds")) {
            return TimeUnit.SECONDS;
        }
        if (unit.equalsIgnoreCase("minute") || unit.equalsIgnoreCase("minutes")) {
            return TimeUnit.MINUTES;
        }
        if (unit.equalsIgnoreCase("hour") || unit.equalsIgnoreCase("hours")) {
            return TimeUnit.HOURS;
        }
        if (unit.equalsIgnoreCase("day") || unit.equalsIgnoreCase("days")) {
            return TimeUnit.DAYS;
        }
        throw new IllegalArgumentException("Unknown time unit: " + unit);
    }
}

