/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain.conditions;

import java.util.ArrayList;
import java.util.List;
import org.drools.ansible.rulebook.integration.api.RuleGenerationContext;
import org.drools.ansible.rulebook.integration.api.domain.conditions.Condition;
import org.drools.ansible.rulebook.integration.api.domain.conditions.OnceWithinDefinition;
import org.drools.ansible.rulebook.integration.api.rulesmodel.ParsedCondition;
import org.drools.model.Condition;
import org.drools.model.Index;
import org.drools.model.PrototypeDSL;
import org.drools.model.PrototypeExpression;
import org.drools.model.view.CombinedExprViewItem;
import org.drools.model.view.ViewItem;

public class AstCondition
implements Condition {
    private final RuleGenerationContext ruleContext;
    private Condition rootCondition;

    public AstCondition(RuleGenerationContext ruleContext) {
        this.ruleContext = ruleContext;
    }

    public AllCondition all() {
        AllCondition allCondition = new AllCondition(this.ruleContext);
        this.rootCondition = allCondition;
        return allCondition;
    }

    public AnyCondition any() {
        AnyCondition anyCondition = new AnyCondition(this.ruleContext);
        this.rootCondition = anyCondition;
        return anyCondition;
    }

    @Override
    public ViewItem toPattern(RuleGenerationContext ruleContext) {
        return this.rootCondition.toPattern(ruleContext);
    }

    public static class SingleCondition<P extends MultipleConditions>
    implements Condition {
        private final P parent;
        private final ParsedCondition parsedCondition;
        private PrototypeDSL.PrototypePatternDef pattern;
        private RuleGenerationContext ruleContext;

        public SingleCondition(P parent, PrototypeExpression left, Index.ConstraintType operator, PrototypeExpression right) {
            this(parent, new ParsedCondition(left, operator, right));
        }

        public SingleCondition(P parent, ParsedCondition parsedCondition) {
            this.parent = parent;
            this.parsedCondition = parsedCondition;
        }

        void setRuleContext(RuleGenerationContext ruleContext) {
            this.ruleContext = ruleContext;
        }

        private PrototypeDSL.PrototypePatternDef getPattern(RuleGenerationContext ruleContext) {
            if (this.pattern == null) {
                this.pattern = ruleContext.getOrCreatePattern(ruleContext.generateBinding(), "DROOLS_PROTOTYPE");
            }
            return this.pattern;
        }

        public SingleCondition withPatternBinding(String patternBinding) {
            return this.withPatternBinding(this.ruleContext, patternBinding);
        }

        SingleCondition withPatternBinding(RuleGenerationContext ruleContext, String patternBinding) {
            if (this.parent != null) {
                ((MultipleConditions)this.parent).beforeBinding();
            }
            this.pattern = ruleContext.getOrCreatePattern(patternBinding, "DROOLS_PROTOTYPE");
            if (this.parent != null) {
                ((MultipleConditions)this.parent).afterBinding();
            }
            return this;
        }

        @Override
        public ViewItem toPattern(RuleGenerationContext ruleContext) {
            ViewItem pattern = this.parsedCondition.addConditionToPattern(ruleContext, this.getPattern(ruleContext));
            OnceWithinDefinition onceWithin = ruleContext.getOnceWithin();
            if (onceWithin != null) {
                return onceWithin.appendGuardPattern(ruleContext, pattern);
            }
            return pattern;
        }

        public SingleCondition<P> addSingleCondition(PrototypeExpression left, Index.ConstraintType operator, PrototypeExpression right) {
            return ((MultipleConditions)this.parent).addSingleCondition(left, operator, right);
        }
    }

    public static class OrCondition
    implements Condition {
        private Condition lhs;
        private Condition rhs;

        public OrCondition withLhs(Condition condition) {
            this.lhs = condition;
            return this;
        }

        public OrCondition withRhs(Condition condition) {
            this.rhs = condition;
            return this;
        }

        @Override
        public ViewItem toPattern(RuleGenerationContext ruleContext) {
            PrototypeDSL.PrototypePatternDef pattern = ruleContext.getOrCreatePattern(ruleContext.generateBinding(), "DROOLS_PROTOTYPE");
            pattern = pattern.or();
            ((SingleCondition)this.lhs).parsedCondition.addConditionToPattern(ruleContext, pattern);
            ((SingleCondition)this.rhs).parsedCondition.addConditionToPattern(ruleContext, pattern);
            return pattern.endOr();
        }
    }

    public static class AndCondition
    implements Condition {
        private Condition lhs;
        private Condition rhs;

        public AndCondition withLhs(Condition condition) {
            this.lhs = condition;
            return this;
        }

        public AndCondition withRhs(Condition condition) {
            this.rhs = condition;
            return this;
        }

        @Override
        public ViewItem toPattern(RuleGenerationContext ruleContext) {
            this.lhs.toPattern(ruleContext);
            return this.rhs.toPattern(ruleContext);
        }
    }

    public static class AnyCondition
    extends MultipleConditions<AnyCondition> {
        public AnyCondition(RuleGenerationContext ruleContext) {
            super(ruleContext);
        }

        @Override
        protected Condition.Type getConditionType() {
            return Condition.Type.OR;
        }

        @Override
        protected void beforeBinding() {
            this.ruleContext.pushContext();
        }

        @Override
        protected void afterBinding() {
            this.ruleContext.popContext();
        }
    }

    public static class AllCondition
    extends MultipleConditions<AllCondition> {
        public AllCondition(RuleGenerationContext ruleContext) {
            super(ruleContext);
        }

        @Override
        protected Condition.Type getConditionType() {
            return Condition.Type.AND;
        }
    }

    public static abstract class MultipleConditions<T extends MultipleConditions>
    implements Condition {
        protected final RuleGenerationContext ruleContext;
        protected final List<Condition> conditions = new ArrayList<Condition>();

        public MultipleConditions(RuleGenerationContext ruleContext) {
            this.ruleContext = ruleContext;
        }

        protected abstract Condition.Type getConditionType();

        @Override
        public ViewItem toPattern(RuleGenerationContext ruleContext) {
            if (this.conditions.size() == 1) {
                return this.conditions.get(0).toPattern(ruleContext);
            }
            if (ruleContext.getOnceWithin() != null) {
                throw new IllegalArgumentException("once_within is only allowed with a single event");
            }
            return new CombinedExprViewItem(this.getConditionType(), (ViewItem[])this.conditions.stream().map(subC -> subC.toPattern(ruleContext)).toArray(ViewItem[]::new));
        }

        public MultipleConditions addCondition(Condition condition) {
            this.conditions.add(condition);
            return this;
        }

        public SingleCondition<T> addSingleCondition(PrototypeExpression left, Index.ConstraintType operator, PrototypeExpression right) {
            SingleCondition<MultipleConditions> singleCondition = new SingleCondition<MultipleConditions>(this, left, operator, right);
            singleCondition.setRuleContext(this.ruleContext);
            this.conditions.add(singleCondition);
            return singleCondition;
        }

        protected void beforeBinding() {
        }

        protected void afterBinding() {
        }
    }
}

