/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.ansible.rulebook.integration.api.RuleConfigurationOption;
import org.drools.ansible.rulebook.integration.api.RuleConfigurationOptions;
import org.drools.ansible.rulebook.integration.api.RuleGenerationContext;
import org.drools.ansible.rulebook.integration.api.RulesExecutionController;
import org.drools.ansible.rulebook.integration.api.domain.Rule;
import org.drools.ansible.rulebook.integration.api.domain.RuleContainer;
import org.drools.model.DSL;
import org.drools.model.Drools;
import org.drools.model.Model;
import org.drools.model.PatternDSL;
import org.drools.model.PrototypeFact;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.impl.ModelImpl;
import org.drools.model.view.ViewItem;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RulesSet {
    private String name;
    private List<String> hosts;
    private List<RuleContainer> rules;
    private RuleConfigurationOptions options;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    public Model toExecModel(RulesExecutionController rulesExecutionController) {
        AtomicInteger ruleCounter = new AtomicInteger(0);
        ModelImpl model = new ModelImpl();
        this.rules.stream().map(RuleContainer::getRule).map(r -> r.createRuleGenerationContext(this.options)).flatMap(rule -> RulesSet.toExecModelRules(rule, rulesExecutionController, ruleCounter).stream()).forEach(model::addRule);
        return model;
    }

    private static List<org.drools.model.Rule> toExecModelRules(Rule rule, RulesExecutionController rulesExecutionController, AtomicInteger ruleCounter) {
        RuleGenerationContext ruleContext = rule.getRuleGenerationContext();
        ViewItem pattern = rule.getCondition().toPattern(ruleContext);
        ConsequenceBuilder.AbstractValidBuilder consequence = ruleContext.getConsequenceVariable() != null ? DSL.on(ruleContext.getConsequenceVariable()).execute((drools, fact) -> {
            ruleContext.executeSyntheticConsequence((Drools)drools, (PrototypeFact)fact);
            RulesSet.defaultConsequence(rule, rulesExecutionController, drools);
        }) : DSL.execute(drools -> RulesSet.defaultConsequence(rule, rulesExecutionController, drools));
        Object ruleName = rule.getName() != null ? rule.getName() : "r_" + ruleCounter.getAndIncrement();
        org.drools.model.Rule generatedRule = PatternDSL.rule((String)ruleName).build(pattern, consequence);
        org.drools.model.Rule syntheticRule = ruleContext.getSyntheticRule();
        return syntheticRule == null ? Arrays.asList(generatedRule) : Arrays.asList(generatedRule, syntheticRule);
    }

    private static void defaultConsequence(Rule rule, RulesExecutionController rulesExecutionController, Drools drools) {
        if (rulesExecutionController.executeActions()) {
            rule.getAction().execute(drools);
        }
    }

    public void setRules(List<RuleContainer> rules) {
        this.rules = rules;
    }

    public Rule addRule() {
        return this.addRule(null);
    }

    public Rule addRule(String name) {
        Rule rule = new Rule();
        rule.setName(name);
        rule.createRuleGenerationContext(this.options);
        RuleContainer ruleContainer = new RuleContainer();
        ruleContainer.setRule(rule);
        if (this.rules == null) {
            this.rules = new ArrayList<RuleContainer>();
        }
        this.rules.add(ruleContainer);
        return rule;
    }

    public boolean hasOption(RuleConfigurationOption option) {
        return this.options != null && this.options.hasOption(option);
    }

    public RulesSet withOptions(RuleConfigurationOptions options) {
        this.options = options;
        return this;
    }

    public String toString() {
        return "RulesSet{name='" + this.name + "', hosts='" + this.hosts + "', rules=" + this.rules + "}";
    }
}

