/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.domain;

import java.util.HashMap;
import java.util.Map;
import org.drools.ansible.rulebook.integration.api.RuleGenerationContext;
import org.drools.core.facttemplates.Fact;
import org.kie.api.runtime.rule.Match;

public class RuleMatch {
    private final String ruleName;
    private final Map<String, Object> facts;

    public RuleMatch(String ruleName, Map<String, Object> facts) {
        this.ruleName = ruleName;
        this.facts = facts;
    }

    public static RuleMatch from(Match match) {
        String ruleName = match.getRule().getName();
        HashMap<String, Object> facts = new HashMap<String, Object>();
        for (String decl : match.getDeclarationIds()) {
            Object value = match.getDeclarationValue(decl);
            if (value instanceof Fact) {
                Fact fact = (Fact)value;
                Map<String, Object> map = RuleMatch.toNestedMap(fact.asMap());
                if (RuleGenerationContext.isGeneratedBinding(decl)) {
                    facts.putAll(map);
                    continue;
                }
                facts.put(decl, map);
                continue;
            }
            facts.put(decl, value);
        }
        return new RuleMatch(ruleName, facts);
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public Map<String, Object> getFacts() {
        return this.facts;
    }

    public static Map<String, Object> toNestedMap(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        map.entrySet().forEach(e -> RuleMatch.addToNestedMap(result, (String)e.getKey(), e.getValue()));
        return result;
    }

    private static void addToNestedMap(Map<String, Object> result, String key, Object value) {
        int dotPos = key.indexOf(46);
        if (dotPos < 0) {
            result.put(key, value);
        } else {
            RuleMatch.addToNestedMap((Map)result.computeIfAbsent(key.substring(0, dotPos), s -> new HashMap()), key.substring(dotPos + 1), value);
        }
    }

    public String toString() {
        return "RuleMatch{ruleName='" + this.ruleName + "', facts=" + this.facts + "}";
    }
}

