/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.drools.ansible.rulebook.integration.api.RulesExecutionController;
import org.drools.core.facttemplates.Fact;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.time.SessionPseudoClock;

class RulesExecutorSession {
    private final KieSession kieSession;
    private final RulesExecutionController rulesExecutionController;

    public RulesExecutorSession(KieSession kieSession, RulesExecutionController rulesExecutionController) {
        this.kieSession = kieSession;
        this.rulesExecutionController = rulesExecutionController;
    }

    public Collection<? extends Object> getObjects() {
        return this.kieSession.getObjects();
    }

    public FactHandle insert(Object object) {
        return this.kieSession.insert(object);
    }

    public void delete(FactHandle fh) {
        this.kieSession.delete(fh);
    }

    public boolean deleteFact(Fact toBeRetracted) {
        return this.kieSession.getFactHandles(o -> o instanceof Fact && Objects.equals(((Fact)o).asMap(), toBeRetracted.asMap())).stream().findFirst().map(fh -> {
            this.kieSession.delete((FactHandle)fh);
            return true;
        }).orElse(false);
    }

    public int fireAllRules() {
        return this.kieSession.fireAllRules();
    }

    public int fireAllRules(AgendaFilter agendaFilter) {
        return this.kieSession.fireAllRules(agendaFilter);
    }

    public void dispose() {
        this.kieSession.dispose();
    }

    public long rulesCount() {
        return this.kieSession.getKieBase().getKiePackages().stream().mapToLong(p -> p.getRules().size()).sum();
    }

    public void advanceTime(long amount, TimeUnit unit) {
        SessionPseudoClock clock = (SessionPseudoClock)this.kieSession.getSessionClock();
        clock.advanceTime(amount, unit);
    }

    public boolean isExecuteActions() {
        return this.rulesExecutionController.executeActions();
    }

    public void setExecuteActions(boolean executeActions) {
        this.rulesExecutionController.setExecuteActions(executeActions);
    }
}

