/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api;

import java.util.concurrent.atomic.AtomicLong;
import org.drools.ansible.rulebook.integration.api.RuleConfigurationOption;
import org.drools.ansible.rulebook.integration.api.RuleFormat;
import org.drools.ansible.rulebook.integration.api.RuleNotation;
import org.drools.ansible.rulebook.integration.api.RulesExecutionController;
import org.drools.ansible.rulebook.integration.api.RulesExecutor;
import org.drools.ansible.rulebook.integration.api.RulesExecutorContainer;
import org.drools.ansible.rulebook.integration.api.RulesExecutorSession;
import org.drools.ansible.rulebook.integration.api.domain.RulesSet;
import org.drools.core.ClockType;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.model.Model;
import org.drools.modelcompiler.KieBaseBuilder;
import org.kie.api.KieServices;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseMutabilityOption;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.ClockTypeOption;

public class RulesExecutorFactory {
    private static final AtomicLong ID_GENERATOR = new AtomicLong(1L);

    public static RulesExecutor createFromYaml(String yaml) {
        return RulesExecutorFactory.createFromYaml(RuleNotation.CoreNotation.INSTANCE, yaml);
    }

    public static RulesExecutor createFromYaml(RuleNotation notation, String yaml) {
        return RulesExecutorFactory.create(RuleFormat.YAML, notation, yaml);
    }

    public static RulesExecutor createFromJson(String json) {
        return RulesExecutorFactory.createFromJson(RuleNotation.CoreNotation.INSTANCE, json);
    }

    public static RulesExecutor createFromJson(RuleNotation notation, String json) {
        return RulesExecutorFactory.create(RuleFormat.JSON, notation, json);
    }

    private static RulesExecutor create(RuleFormat format, RuleNotation notation, String text) {
        return RulesExecutorFactory.createRulesExecutor(notation.toRulesSet(format, text));
    }

    public static RulesExecutor createRulesExecutor(RulesSet rulesSet) {
        RulesExecutor rulesExecutor = new RulesExecutor(RulesExecutorFactory.createRulesExecutorSession(rulesSet), ID_GENERATOR.getAndIncrement());
        return RulesExecutorContainer.INSTANCE.register(rulesExecutor);
    }

    private static RulesExecutorSession createRulesExecutorSession(RulesSet rulesSet) {
        RulesExecutionController rulesExecutionController = new RulesExecutionController();
        KieSession kieSession = RulesExecutorFactory.createKieSession(rulesSet, rulesExecutionController);
        return new RulesExecutorSession(kieSession, rulesExecutionController);
    }

    private static KieSession createKieSession(RulesSet rulesSet, RulesExecutionController rulesExecutionController) {
        Model model = rulesSet.toExecModel(rulesExecutionController);
        InternalKnowledgeBase kieBase = KieBaseBuilder.createKieBaseFromModel(model, KieBaseMutabilityOption.DISABLED, rulesSet.hasOption(RuleConfigurationOption.EVENTS_PROCESSING) ? EventProcessingOption.STREAM : EventProcessingOption.CLOUD);
        if (rulesSet.hasOption(RuleConfigurationOption.USE_PSEUDO_CLOCK)) {
            KieSessionConfiguration conf = KieServices.get().newKieSessionConfiguration();
            conf.setOption(ClockTypeOption.get(ClockType.PSEUDO_CLOCK.getId()));
            return kieBase.newKieSession(conf, null);
        }
        return kieBase.newKieSession();
    }
}

