/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.drools.ansible.rulebook.integration.api.RulesExecutorContainer;
import org.drools.ansible.rulebook.integration.api.RulesExecutorSession;
import org.drools.ansible.rulebook.integration.api.rulesmodel.RulesModelUtil;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.facttemplates.Fact;
import org.json.JSONObject;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;

public class RulesExecutor {
    public static final String SYNTHETIC_RULE_TAG = "SYNTHETIC_RULE";
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final RulesExecutorSession rulesExecutorSession;
    private final long id;
    private final Set<Long> ephemeralFactHandleIds = ConcurrentHashMap.newKeySet();

    RulesExecutor(RulesExecutorSession rulesExecutorSession, long id) {
        this.rulesExecutorSession = rulesExecutorSession;
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void dispose() {
        RulesExecutorContainer.INSTANCE.dispose(this);
        this.rulesExecutorSession.dispose();
    }

    public long rulesCount() {
        return this.rulesExecutorSession.rulesCount();
    }

    public int executeFacts(String json) {
        return this.executeFacts(new JSONObject(json).toMap());
    }

    public int executeFacts(Map<String, Object> factMap) {
        this.insertFact(factMap);
        return this.rulesExecutorSession.fireAllRules();
    }

    public List<Match> processFacts(String json) {
        return this.processFacts(new JSONObject(json).toMap());
    }

    public List<Match> processFacts(Map<String, Object> factMap) {
        return this.process(factMap, false);
    }

    public List<Match> processEvents(String json) {
        return this.processEvents(new JSONObject(json).toMap());
    }

    public List<Match> processEvents(Map<String, Object> factMap) {
        return this.process(factMap, true);
    }

    private List<Match> process(Map<String, Object> factMap, boolean event) {
        Collection<FactHandle> fhs = this.insertFacts(factMap, event);
        if (event) {
            fhs.stream().map(InternalFactHandle.class::cast).map(InternalFactHandle::getId).forEach(this.ephemeralFactHandleIds::add);
        }
        List<Match> matches = this.findMatchedRules();
        return !event || matches.size() < 2 ? matches : matches.stream().takeWhile(match -> match.getRule().getName().equals(((Match)matches.get(0)).getRule().getName())).collect(Collectors.toList());
    }

    private List<Match> findMatchedRules() {
        this.rulesExecutorSession.setExecuteActions(false);
        RegisterOnlyAgendaFilter filter = new RegisterOnlyAgendaFilter(this.rulesExecutorSession, this.ephemeralFactHandleIds);
        this.rulesExecutorSession.fireAllRules(filter);
        this.rulesExecutorSession.setExecuteActions(true);
        return filter.finalizeAndGetResults();
    }

    public boolean executeActions() {
        return this.rulesExecutorSession.isExecuteActions();
    }

    private Collection<FactHandle> insertFacts(Map<String, Object> factMap, boolean event) {
        String key;
        String string = key = event ? "events" : "facts";
        if (factMap.size() == 1 && factMap.containsKey(key)) {
            return ((List)factMap.get(key)).stream().flatMap(map -> this.insertFacts((Map<String, Object>)map, event).stream()).collect(Collectors.toList());
        }
        return Collections.singletonList(this.insertFact(factMap));
    }

    public FactHandle insertFact(Map<String, Object> factMap) {
        return this.rulesExecutorSession.insert(RulesModelUtil.mapToFact(factMap));
    }

    public int executeRetract(String json) {
        return this.retractFact(new JSONObject(json).toMap()) ? this.rulesExecutorSession.fireAllRules() : 0;
    }

    public List<Match> processRetract(String json) {
        return this.retractFact(new JSONObject(json).toMap()) ? this.findMatchedRules() : Collections.emptyList();
    }

    public boolean retractFact(Map<String, Object> factMap) {
        return this.rulesExecutorSession.deleteFact(RulesModelUtil.mapToFact(factMap));
    }

    public Collection<?> getAllFacts() {
        return this.rulesExecutorSession.getObjects();
    }

    public List<Map<String, Object>> getAllFactsAsMap() {
        return this.getAllFacts().stream().map(Fact.class::cast).map(Fact::asMap).collect(Collectors.toList());
    }

    public String getAllFactsAsJson() {
        try {
            return OBJECT_MAPPER.writeValueAsString(this.getAllFactsAsMap());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void advanceTime(long amount, TimeUnit unit) {
        this.rulesExecutorSession.advanceTime(amount, unit);
    }

    private static class RegisterOnlyAgendaFilter
    implements AgendaFilter {
        private final RulesExecutorSession rulesExecutorSession;
        private final Set<Long> ephemeralFactHandleIds;
        private final Set<Match> matchedRules = new LinkedHashSet<Match>();
        private final List<FactHandle> factsToBeDeleted = new ArrayList<FactHandle>();

        private RegisterOnlyAgendaFilter(RulesExecutorSession rulesExecutorSession, Set<Long> ephemeralFactHandleIds) {
            this.rulesExecutorSession = rulesExecutorSession;
            this.ephemeralFactHandleIds = ephemeralFactHandleIds;
        }

        @Override
        public boolean accept(Match match) {
            if (match.getRule().getMetaData().get(RulesExecutor.SYNTHETIC_RULE_TAG) != null) {
                return true;
            }
            this.matchedRules.add(match);
            if (!this.ephemeralFactHandleIds.isEmpty()) {
                for (FactHandle factHandle : match.getFactHandles()) {
                    if (!this.ephemeralFactHandleIds.remove(((InternalFactHandle)factHandle).getId())) continue;
                    this.factsToBeDeleted.add(factHandle);
                }
            }
            return true;
        }

        public List<Match> finalizeAndGetResults() {
            this.factsToBeDeleted.forEach(this.rulesExecutorSession::delete);
            return new ArrayList<Match>(this.matchedRules);
        }
    }
}

