/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.drools.ansible.rulebook.integration.api.RuleConfigurationOption;
import org.drools.ansible.rulebook.integration.api.RuleConfigurationOptions;
import org.drools.ansible.rulebook.integration.api.domain.conditions.OnceWithinDefinition;
import org.drools.ansible.rulebook.integration.api.rulesmodel.PrototypeFactory;
import org.drools.model.Drools;
import org.drools.model.PrototypeDSL;
import org.drools.model.PrototypeFact;
import org.drools.model.PrototypeVariable;
import org.drools.model.Rule;

public class RuleGenerationContext {
    private final RuleConfigurationOptions options;
    private final StackedContext<String, PrototypeDSL.PrototypePatternDef> patterns = new StackedContext();
    private int bindingsCounter = 0;
    private OnceWithinDefinition onceWithin;

    public RuleGenerationContext(RuleConfigurationOptions options) {
        this.options = options;
    }

    public PrototypeDSL.PrototypePatternDef getOrCreatePattern(String binding, String name) {
        return this.patterns.computeIfAbsent(binding, b -> PrototypeDSL.protoPattern(PrototypeDSL.variable(PrototypeFactory.getPrototype(name), b)));
    }

    public PrototypeVariable getPatternVariable(String binding) {
        PrototypeDSL.PrototypePatternDef patternDef = this.patterns.get(binding);
        return patternDef != null ? (PrototypeVariable)patternDef.getFirstVariable() : null;
    }

    public boolean isExistingBoundVariable(String binding) {
        return this.patterns.get(binding) != null;
    }

    public PrototypeDSL.PrototypePatternDef getBoundPattern(String binding) {
        return this.patterns.get(binding);
    }

    public void pushContext() {
        this.patterns.pushContext();
    }

    public void popContext() {
        this.patterns.popContext();
    }

    public String generateBinding() {
        String binding = this.bindingsCounter == 0 ? "m" : "m_" + this.bindingsCounter;
        ++this.bindingsCounter;
        return binding;
    }

    public boolean hasOption(RuleConfigurationOption option) {
        return this.options != null && this.options.hasOption(option);
    }

    public static boolean isGeneratedBinding(String binding) {
        return binding.equals("m") || binding.startsWith("m_");
    }

    public OnceWithinDefinition getOnceWithin() {
        return this.onceWithin;
    }

    public void setOnceWithin(OnceWithinDefinition onceWithin) {
        this.onceWithin = onceWithin;
    }

    public PrototypeVariable getConsequenceVariable() {
        return this.onceWithin != null ? this.onceWithin.getGuardedVariable() : null;
    }

    public void executeSyntheticConsequence(Drools drools, PrototypeFact fact) {
        if (this.onceWithin != null) {
            this.onceWithin.insertGuardConsequence(this).accept(drools, fact);
        }
    }

    public Rule getSyntheticRule() {
        return this.onceWithin != null ? this.onceWithin.cleanupRule(this) : null;
    }

    private static class StackedContext<K, V> {
        private final Deque<Map<K, V>> stack = new ArrayDeque<Map<K, V>>();

        public StackedContext() {
            this.pushContext();
        }

        public void pushContext() {
            this.stack.addFirst(new HashMap());
        }

        public void popContext() {
            this.stack.removeFirst();
        }

        public V get(K key) {
            for (Map<K, V> map : this.stack) {
                V value = map.get(key);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        public void put(K key, V value) {
            this.stack.getFirst().put(key, value);
        }

        public V computeIfAbsent(K key, Function<K, V> f) {
            V value = this.get(key);
            if (value != null) {
                return value;
            }
            value = f.apply(key);
            this.put(key, value);
            return value;
        }
    }
}

