# ElectricPy
*Electrical-Engineering-for-Python*

Python Libraries with functions and constants related to electrical engineering.

The functions and constants that make up these modules represent a library of material compiled with the intent of being used primarily
for research, development, education, and exploration in the realm of electrical engineering.

Check out our full documentation: https://engineerjoe440.github.io/ElectricPy/html/

### Special thanks to:
- Stephen Weeks | Student - University of Idaho
- Jeremy Perhac | Student - University of Idaho
- Daniel Allen | Student - Universtiy of Idaho
- Dr. Dennis Sullivan | Proffessor - University of Idaho
- Dr. Brian Johnson | Proffessor - University of Idaho
- Dr. Joe Law | Proffessor - University of Idaho
- StackOverflow user gg349
- Shaurya Uppal | Online Code Contributor
- Paul Ortman | Power Quality Engineer - Idaho Power | Instructor - University of Idaho


### Dependencies:
- NUMPY
- MATPLOTLIB
- SCIPY
- SYMPY
- NUMDIFFTOOLS


## INSTALLATION:
 1. Install required dependencies (NUMPY, SCIPY, SYMPY, NUMDIFFTOOLS, and MATPLOTLIB)
    - `pip install numpy`
    - `pip install scipy`
    - `pip install matplotlib`
    - `pip install sympy`
    - `pip install numdifftools`
  
 2. Install *electricpy*
    - `pip install electricpy`
  
 3. Check installation success in Python environment

   ```python
   import electricpy
   electricpy._version_
   ```

## To Do List:
- Port Remaining Functions from ELECTRICALPYTHON
    - Add Heat Sink Solver
    - DC/DC Converters
    - DC/AC Converters
    - Stationary and Synchronous Reference Frame conversion Matricies/Constants
    - Induction Machine slip finder
    - CEV reader/writer functions
    

## Contact:
For more information regarding this resource, please contact Joe Stanley
- <stan3926@vandals.uidaho.edu>
- <joe_stanley@selinc.com>

## License and Usage:
ElectricPy is licensed under the standard MIT license, and as such, you are permitted
to use this resource as you see fit. Please feel free to ask questions, suggest edits
and report bugs or other issues.