# -*- coding: utf-8 -*-
#
# Copyright (c) 2015, Alcatel-Lucent Inc, 2017 Nokia
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of the copyright holder nor the names of its contributors
#       may be used to endorse or promote products derived from this software without
#       specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.




from .fetchers import NUPermissionsFetcher


from .fetchers import NUMetadatasFetcher


from .fetchers import NUAlarmsFetcher


from .fetchers import NUGlobalMetadatasFetcher


from .fetchers import NUVMsFetcher


from .fetchers import NUJobsFetcher


from .fetchers import NUMonitoringPortsFetcher


from .fetchers import NUContainersFetcher


from .fetchers import NUControllerVRSLinksFetcher


from .fetchers import NUVPortsFetcher


from .fetchers import NUHSCsFetcher


from .fetchers import NUVSCsFetcher


from .fetchers import NUStatisticsFetcher


from .fetchers import NUMultiNICVPortsFetcher


from .fetchers import NUEventLogsFetcher

from bambou import NURESTObject


class NUVRS(NURESTObject):
    """ Represents a VRS in the VSD

        Notes:
            System Monitoring details for VRS connected to VSC or HSC
    """

    __rest_name__ = "vrs"
    __resource_name__ = "vrss"

    
    ## Constants
    
    CONST_STATUS_DOWN = "DOWN"
    
    CONST_HYPERVISOR_CONNECTION_STATE_UP = "UP"
    
    CONST_HYPERVISOR_CONNECTION_STATE_ADMIN_DOWN = "ADMIN_DOWN"
    
    CONST_PERSONALITY_NSGDUC = "NSGDUC"
    
    CONST_PERSONALITY_NONE = "NONE"
    
    CONST_HYPERVISOR_CONNECTION_STATE_DOWN = "DOWN"
    
    CONST_PERSONALITY_VRS = "VRS"
    
    CONST_PERSONALITY_NSG = "NSG"
    
    CONST_ROLE_MASTER = "MASTER"
    
    CONST_STATUS_ADMIN_DOWN = "ADMIN_DOWN"
    
    CONST_ROLE_SLAVE = "SLAVE"
    
    CONST_LICENSED_STATE_LICENSED = "LICENSED"
    
    CONST_PERSONALITY_HARDWARE_VTEP = "HARDWARE_VTEP"
    
    CONST_PERSONALITY_VRSB = "VRSB"
    
    CONST_STATUS_UP = "UP"
    
    CONST_PERSONALITY_NUAGE_210_WBX_48_S = "NUAGE_210_WBX_48_S"
    
    CONST_PERSONALITY_VRSG = "VRSG"
    
    CONST_ENTITY_SCOPE_ENTERPRISE = "ENTERPRISE"
    
    CONST_PERSONALITY_NUAGE_210_WBX_32_Q = "NUAGE_210_WBX_32_Q"
    
    CONST_ENTITY_SCOPE_GLOBAL = "GLOBAL"
    
    CONST_ROLE_NONE = "NONE"
    
    CONST_LICENSED_STATE_UNLICENSED = "UNLICENSED"
    
    CONST_PERSONALITY_NSGBR = "NSGBR"
    
    

    def __init__(self, **kwargs):
        """ Initializes a VRS instance

            Notes:
                You can specify all parameters while calling this methods.
                A special argument named `data` will enable you to load the
                object from a Python dictionary

            Examples:
                >>> vrs = NUVRS(id=u'xxxx-xxx-xxx-xxx', name=u'VRS')
                >>> vrs = NUVRS(data=my_dict)
        """

        super(NUVRS, self).__init__()

        # Read/Write Attributes
        
        self._issu_failure_reason = None
        self._issu_state = None
        self._name = None
        self._management_ip = None
        self._parent_ids = None
        self._last_event_name = None
        self._last_event_object = None
        self._last_event_timestamp = None
        self._last_issu_state = None
        self._last_state_change = None
        self._last_updated_by = None
        self._last_updated_date = None
        self._gateway_uuid = None
        self._db_synced = None
        self._address = None
        self._peak_cpuusage = None
        self._peak_memory_usage = None
        self._personality = None
        self._description = None
        self._messages = None
        self._revert_behavior_enabled = None
        self._revert_completed = None
        self._revert_count = None
        self._revert_failed_count = None
        self._licensed_state = None
        self._disks = None
        self._embedded_metadata = None
        self._entity_scope = None
        self._location = None
        self._role = None
        self._uptime = None
        self._creation_date = None
        self._primary_vsc_connection_lost = None
        self._product_version = None
        self._is_resilient = None
        self._status = None
        self._multi_nic_vport_enabled = None
        self._number_of_bridge_interfaces = None
        self._number_of_containers = None
        self._number_of_host_interfaces = None
        self._number_of_virtual_machines = None
        self._current_cpuusage = None
        self._current_memory_usage = None
        self._average_cpuusage = None
        self._average_memory_usage = None
        self._owner = None
        self._external_id = None
        self._hypervisor_connection_state = None
        self._hypervisor_identifier = None
        self._hypervisor_name = None
        self._hypervisor_type = None
        
        self.expose_attribute(local_name="issu_failure_reason", remote_name="ISSUFailureReason", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="issu_state", remote_name="ISSUState", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="name", remote_name="name", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="management_ip", remote_name="managementIP", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="parent_ids", remote_name="parentIDs", attribute_type=list, is_required=False, is_unique=False)
        self.expose_attribute(local_name="last_event_name", remote_name="lastEventName", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="last_event_object", remote_name="lastEventObject", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="last_event_timestamp", remote_name="lastEventTimestamp", attribute_type=int, is_required=False, is_unique=False)
        self.expose_attribute(local_name="last_issu_state", remote_name="lastISSUState", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="last_state_change", remote_name="lastStateChange", attribute_type=int, is_required=False, is_unique=False)
        self.expose_attribute(local_name="last_updated_by", remote_name="lastUpdatedBy", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="last_updated_date", remote_name="lastUpdatedDate", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="gateway_uuid", remote_name="gatewayUUID", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="db_synced", remote_name="dbSynced", attribute_type=bool, is_required=False, is_unique=False)
        self.expose_attribute(local_name="address", remote_name="address", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="peak_cpuusage", remote_name="peakCPUUsage", attribute_type=float, is_required=False, is_unique=False)
        self.expose_attribute(local_name="peak_memory_usage", remote_name="peakMemoryUsage", attribute_type=float, is_required=False, is_unique=False)
        self.expose_attribute(local_name="personality", remote_name="personality", attribute_type=str, is_required=False, is_unique=False, choices=[u'HARDWARE_VTEP', u'NONE', u'NSG', u'NSGBR', u'NSGDUC', u'NUAGE_210_WBX_32_Q', u'NUAGE_210_WBX_48_S', u'VRS', u'VRSB', u'VRSG'])
        self.expose_attribute(local_name="description", remote_name="description", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="messages", remote_name="messages", attribute_type=list, is_required=False, is_unique=False)
        self.expose_attribute(local_name="revert_behavior_enabled", remote_name="revertBehaviorEnabled", attribute_type=bool, is_required=False, is_unique=False)
        self.expose_attribute(local_name="revert_completed", remote_name="revertCompleted", attribute_type=bool, is_required=False, is_unique=False)
        self.expose_attribute(local_name="revert_count", remote_name="revertCount", attribute_type=int, is_required=False, is_unique=False)
        self.expose_attribute(local_name="revert_failed_count", remote_name="revertFailedCount", attribute_type=int, is_required=False, is_unique=False)
        self.expose_attribute(local_name="licensed_state", remote_name="licensedState", attribute_type=str, is_required=False, is_unique=False, choices=[u'LICENSED', u'UNLICENSED'])
        self.expose_attribute(local_name="disks", remote_name="disks", attribute_type=list, is_required=False, is_unique=False)
        self.expose_attribute(local_name="embedded_metadata", remote_name="embeddedMetadata", attribute_type=list, is_required=False, is_unique=False)
        self.expose_attribute(local_name="entity_scope", remote_name="entityScope", attribute_type=str, is_required=False, is_unique=False, choices=[u'ENTERPRISE', u'GLOBAL'])
        self.expose_attribute(local_name="location", remote_name="location", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="role", remote_name="role", attribute_type=str, is_required=False, is_unique=False, choices=[u'MASTER', u'NONE', u'SLAVE'])
        self.expose_attribute(local_name="uptime", remote_name="uptime", attribute_type=int, is_required=False, is_unique=False)
        self.expose_attribute(local_name="creation_date", remote_name="creationDate", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="primary_vsc_connection_lost", remote_name="primaryVSCConnectionLost", attribute_type=bool, is_required=False, is_unique=False)
        self.expose_attribute(local_name="product_version", remote_name="productVersion", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="is_resilient", remote_name="isResilient", attribute_type=bool, is_required=False, is_unique=False)
        self.expose_attribute(local_name="status", remote_name="status", attribute_type=str, is_required=False, is_unique=False, choices=[u'ADMIN_DOWN', u'DOWN', u'UP'])
        self.expose_attribute(local_name="multi_nic_vport_enabled", remote_name="multiNICVPortEnabled", attribute_type=bool, is_required=False, is_unique=False)
        self.expose_attribute(local_name="number_of_bridge_interfaces", remote_name="numberOfBridgeInterfaces", attribute_type=int, is_required=False, is_unique=False)
        self.expose_attribute(local_name="number_of_containers", remote_name="numberOfContainers", attribute_type=int, is_required=False, is_unique=False)
        self.expose_attribute(local_name="number_of_host_interfaces", remote_name="numberOfHostInterfaces", attribute_type=int, is_required=False, is_unique=False)
        self.expose_attribute(local_name="number_of_virtual_machines", remote_name="numberOfVirtualMachines", attribute_type=int, is_required=False, is_unique=False)
        self.expose_attribute(local_name="current_cpuusage", remote_name="currentCPUUsage", attribute_type=float, is_required=False, is_unique=False)
        self.expose_attribute(local_name="current_memory_usage", remote_name="currentMemoryUsage", attribute_type=float, is_required=False, is_unique=False)
        self.expose_attribute(local_name="average_cpuusage", remote_name="averageCPUUsage", attribute_type=float, is_required=False, is_unique=False)
        self.expose_attribute(local_name="average_memory_usage", remote_name="averageMemoryUsage", attribute_type=float, is_required=False, is_unique=False)
        self.expose_attribute(local_name="owner", remote_name="owner", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="external_id", remote_name="externalID", attribute_type=str, is_required=False, is_unique=True)
        self.expose_attribute(local_name="hypervisor_connection_state", remote_name="hypervisorConnectionState", attribute_type=str, is_required=False, is_unique=False, choices=[u'ADMIN_DOWN', u'DOWN', u'UP'])
        self.expose_attribute(local_name="hypervisor_identifier", remote_name="hypervisorIdentifier", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="hypervisor_name", remote_name="hypervisorName", attribute_type=str, is_required=False, is_unique=False)
        self.expose_attribute(local_name="hypervisor_type", remote_name="hypervisorType", attribute_type=str, is_required=False, is_unique=False)
        

        # Fetchers
        
        
        self.permissions = NUPermissionsFetcher.fetcher_with_object(parent_object=self, relationship="child")
        
        
        self.metadatas = NUMetadatasFetcher.fetcher_with_object(parent_object=self, relationship="child")
        
        
        self.alarms = NUAlarmsFetcher.fetcher_with_object(parent_object=self, relationship="child")
        
        
        self.global_metadatas = NUGlobalMetadatasFetcher.fetcher_with_object(parent_object=self, relationship="child")
        
        
        self.vms = NUVMsFetcher.fetcher_with_object(parent_object=self, relationship="child")
        
        
        self.jobs = NUJobsFetcher.fetcher_with_object(parent_object=self, relationship="child")
        
        
        self.monitoring_ports = NUMonitoringPortsFetcher.fetcher_with_object(parent_object=self, relationship="child")
        
        
        self.containers = NUContainersFetcher.fetcher_with_object(parent_object=self, relationship="child")
        
        
        self.controller_vrs_links = NUControllerVRSLinksFetcher.fetcher_with_object(parent_object=self, relationship="child")
        
        
        self.vports = NUVPortsFetcher.fetcher_with_object(parent_object=self, relationship="child")
        
        
        self.hscs = NUHSCsFetcher.fetcher_with_object(parent_object=self, relationship="child")
        
        
        self.vscs = NUVSCsFetcher.fetcher_with_object(parent_object=self, relationship="child")
        
        
        self.statistics = NUStatisticsFetcher.fetcher_with_object(parent_object=self, relationship="child")
        
        
        self.multi_nic_vports = NUMultiNICVPortsFetcher.fetcher_with_object(parent_object=self, relationship="child")
        
        
        self.event_logs = NUEventLogsFetcher.fetcher_with_object(parent_object=self, relationship="child")
        

        self._compute_args(**kwargs)

    # Properties
    
    @property
    def issu_failure_reason(self):
        """ Get issu_failure_reason value.

            Notes:
                ISSU (In-Service Software Upgrade) failure reason.

                
                This attribute is named `ISSUFailureReason` in VSD API.
                
        """
        return self._issu_failure_reason

    @issu_failure_reason.setter
    def issu_failure_reason(self, value):
        """ Set issu_failure_reason value.

            Notes:
                ISSU (In-Service Software Upgrade) failure reason.

                
                This attribute is named `ISSUFailureReason` in VSD API.
                
        """
        self._issu_failure_reason = value

    
    @property
    def issu_state(self):
        """ Get issu_state value.

            Notes:
                ISSU (In-Service Software Upgrade) state of this VRS.

                
                This attribute is named `ISSUState` in VSD API.
                
        """
        return self._issu_state

    @issu_state.setter
    def issu_state(self, value):
        """ Set issu_state value.

            Notes:
                ISSU (In-Service Software Upgrade) state of this VRS.

                
                This attribute is named `ISSUState` in VSD API.
                
        """
        self._issu_state = value

    
    @property
    def name(self):
        """ Get name value.

            Notes:
                Identifies the entity with a name.

                
        """
        return self._name

    @name.setter
    def name(self, value):
        """ Set name value.

            Notes:
                Identifies the entity with a name.

                
        """
        self._name = value

    
    @property
    def management_ip(self):
        """ Get management_ip value.

            Notes:
                The management IP of the VRS entity

                
                This attribute is named `managementIP` in VSD API.
                
        """
        return self._management_ip

    @management_ip.setter
    def management_ip(self, value):
        """ Set management_ip value.

            Notes:
                The management IP of the VRS entity

                
                This attribute is named `managementIP` in VSD API.
                
        """
        self._management_ip = value

    
    @property
    def parent_ids(self):
        """ Get parent_ids value.

            Notes:
                Holds VRS controllers ids

                
                This attribute is named `parentIDs` in VSD API.
                
        """
        return self._parent_ids

    @parent_ids.setter
    def parent_ids(self, value):
        """ Set parent_ids value.

            Notes:
                Holds VRS controllers ids

                
                This attribute is named `parentIDs` in VSD API.
                
        """
        self._parent_ids = value

    
    @property
    def last_event_name(self):
        """ Get last_event_name value.

            Notes:
                The last event name from the hypervisor.

                
                This attribute is named `lastEventName` in VSD API.
                
        """
        return self._last_event_name

    @last_event_name.setter
    def last_event_name(self, value):
        """ Set last_event_name value.

            Notes:
                The last event name from the hypervisor.

                
                This attribute is named `lastEventName` in VSD API.
                
        """
        self._last_event_name = value

    
    @property
    def last_event_object(self):
        """ Get last_event_object value.

            Notes:
                The last event object (including metadata) from the hypervisor.

                
                This attribute is named `lastEventObject` in VSD API.
                
        """
        return self._last_event_object

    @last_event_object.setter
    def last_event_object(self, value):
        """ Set last_event_object value.

            Notes:
                The last event object (including metadata) from the hypervisor.

                
                This attribute is named `lastEventObject` in VSD API.
                
        """
        self._last_event_object = value

    
    @property
    def last_event_timestamp(self):
        """ Get last_event_timestamp value.

            Notes:
                The last event timestamp from the hypervisor.

                
                This attribute is named `lastEventTimestamp` in VSD API.
                
        """
        return self._last_event_timestamp

    @last_event_timestamp.setter
    def last_event_timestamp(self, value):
        """ Set last_event_timestamp value.

            Notes:
                The last event timestamp from the hypervisor.

                
                This attribute is named `lastEventTimestamp` in VSD API.
                
        """
        self._last_event_timestamp = value

    
    @property
    def last_issu_state(self):
        """ Get last_issu_state value.

            Notes:
                Last ISSU (In-Service Software Upgrade) state of this VRS.

                
                This attribute is named `lastISSUState` in VSD API.
                
        """
        return self._last_issu_state

    @last_issu_state.setter
    def last_issu_state(self, value):
        """ Set last_issu_state value.

            Notes:
                Last ISSU (In-Service Software Upgrade) state of this VRS.

                
                This attribute is named `lastISSUState` in VSD API.
                
        """
        self._last_issu_state = value

    
    @property
    def last_state_change(self):
        """ Get last_state_change value.

            Notes:
                Last state change timestamp (in millis).

                
                This attribute is named `lastStateChange` in VSD API.
                
        """
        return self._last_state_change

    @last_state_change.setter
    def last_state_change(self, value):
        """ Set last_state_change value.

            Notes:
                Last state change timestamp (in millis).

                
                This attribute is named `lastStateChange` in VSD API.
                
        """
        self._last_state_change = value

    
    @property
    def last_updated_by(self):
        """ Get last_updated_by value.

            Notes:
                ID of the user who last updated the object.

                
                This attribute is named `lastUpdatedBy` in VSD API.
                
        """
        return self._last_updated_by

    @last_updated_by.setter
    def last_updated_by(self, value):
        """ Set last_updated_by value.

            Notes:
                ID of the user who last updated the object.

                
                This attribute is named `lastUpdatedBy` in VSD API.
                
        """
        self._last_updated_by = value

    
    @property
    def last_updated_date(self):
        """ Get last_updated_date value.

            Notes:
                Time stamp when this object was last updated.

                
                This attribute is named `lastUpdatedDate` in VSD API.
                
        """
        return self._last_updated_date

    @last_updated_date.setter
    def last_updated_date(self, value):
        """ Set last_updated_date value.

            Notes:
                Time stamp when this object was last updated.

                
                This attribute is named `lastUpdatedDate` in VSD API.
                
        """
        self._last_updated_date = value

    
    @property
    def gateway_uuid(self):
        """ Get gateway_uuid value.

            Notes:
                UUID of the gateway instance

                
                This attribute is named `gatewayUUID` in VSD API.
                
        """
        return self._gateway_uuid

    @gateway_uuid.setter
    def gateway_uuid(self, value):
        """ Set gateway_uuid value.

            Notes:
                UUID of the gateway instance

                
                This attribute is named `gatewayUUID` in VSD API.
                
        """
        self._gateway_uuid = value

    
    @property
    def db_synced(self):
        """ Get db_synced value.

            Notes:
                Flag to indicate if the ovs database is synced between the NSG pair part of a redundant group

                
                This attribute is named `dbSynced` in VSD API.
                
        """
        return self._db_synced

    @db_synced.setter
    def db_synced(self, value):
        """ Set db_synced value.

            Notes:
                Flag to indicate if the ovs database is synced between the NSG pair part of a redundant group

                
                This attribute is named `dbSynced` in VSD API.
                
        """
        self._db_synced = value

    
    @property
    def address(self):
        """ Get address value.

            Notes:
                The IP of the VRS entity

                
        """
        return self._address

    @address.setter
    def address(self, value):
        """ Set address value.

            Notes:
                The IP of the VRS entity

                
        """
        self._address = value

    
    @property
    def peak_cpuusage(self):
        """ Get peak_cpuusage value.

            Notes:
                Peek CPU usage percentage.

                
                This attribute is named `peakCPUUsage` in VSD API.
                
        """
        return self._peak_cpuusage

    @peak_cpuusage.setter
    def peak_cpuusage(self, value):
        """ Set peak_cpuusage value.

            Notes:
                Peek CPU usage percentage.

                
                This attribute is named `peakCPUUsage` in VSD API.
                
        """
        self._peak_cpuusage = value

    
    @property
    def peak_memory_usage(self):
        """ Get peak_memory_usage value.

            Notes:
                Peek memory usage percentage.

                
                This attribute is named `peakMemoryUsage` in VSD API.
                
        """
        return self._peak_memory_usage

    @peak_memory_usage.setter
    def peak_memory_usage(self, value):
        """ Set peak_memory_usage value.

            Notes:
                Peek memory usage percentage.

                
                This attribute is named `peakMemoryUsage` in VSD API.
                
        """
        self._peak_memory_usage = value

    
    @property
    def personality(self):
        """ Get personality value.

            Notes:
                VRS personality.

                
        """
        return self._personality

    @personality.setter
    def personality(self, value):
        """ Set personality value.

            Notes:
                VRS personality.

                
        """
        self._personality = value

    
    @property
    def description(self):
        """ Get description value.

            Notes:
                Description of the entity.

                
        """
        return self._description

    @description.setter
    def description(self, value):
        """ Set description value.

            Notes:
                Description of the entity.

                
        """
        self._description = value

    
    @property
    def messages(self):
        """ Get messages value.

            Notes:
                An array of degraded messages.

                
        """
        return self._messages

    @messages.setter
    def messages(self, value):
        """ Set messages value.

            Notes:
                An array of degraded messages.

                
        """
        self._messages = value

    
    @property
    def revert_behavior_enabled(self):
        """ Get revert_behavior_enabled value.

            Notes:
                Flag to indicate if the revert behavior took place or not.

                
                This attribute is named `revertBehaviorEnabled` in VSD API.
                
        """
        return self._revert_behavior_enabled

    @revert_behavior_enabled.setter
    def revert_behavior_enabled(self, value):
        """ Set revert_behavior_enabled value.

            Notes:
                Flag to indicate if the revert behavior took place or not.

                
                This attribute is named `revertBehaviorEnabled` in VSD API.
                
        """
        self._revert_behavior_enabled = value

    
    @property
    def revert_completed(self):
        """ Get revert_completed value.

            Notes:
                Flag indicates whether revert was completed successfully.

                
                This attribute is named `revertCompleted` in VSD API.
                
        """
        return self._revert_completed

    @revert_completed.setter
    def revert_completed(self, value):
        """ Set revert_completed value.

            Notes:
                Flag indicates whether revert was completed successfully.

                
                This attribute is named `revertCompleted` in VSD API.
                
        """
        self._revert_completed = value

    
    @property
    def revert_count(self):
        """ Get revert_count value.

            Notes:
                Indicates the number of retries for the revert to take place.

                
                This attribute is named `revertCount` in VSD API.
                
        """
        return self._revert_count

    @revert_count.setter
    def revert_count(self, value):
        """ Set revert_count value.

            Notes:
                Indicates the number of retries for the revert to take place.

                
                This attribute is named `revertCount` in VSD API.
                
        """
        self._revert_count = value

    
    @property
    def revert_failed_count(self):
        """ Get revert_failed_count value.

            Notes:
                This value indicates the number of failed attempts for the revert to happen successfully.

                
                This attribute is named `revertFailedCount` in VSD API.
                
        """
        return self._revert_failed_count

    @revert_failed_count.setter
    def revert_failed_count(self, value):
        """ Set revert_failed_count value.

            Notes:
                This value indicates the number of failed attempts for the revert to happen successfully.

                
                This attribute is named `revertFailedCount` in VSD API.
                
        """
        self._revert_failed_count = value

    
    @property
    def licensed_state(self):
        """ Get licensed_state value.

            Notes:
                Licensed state.

                
                This attribute is named `licensedState` in VSD API.
                
        """
        return self._licensed_state

    @licensed_state.setter
    def licensed_state(self, value):
        """ Set licensed_state value.

            Notes:
                Licensed state.

                
                This attribute is named `licensedState` in VSD API.
                
        """
        self._licensed_state = value

    
    @property
    def disks(self):
        """ Get disks value.

            Notes:
                Set of disk usage details.

                
        """
        return self._disks

    @disks.setter
    def disks(self, value):
        """ Set disks value.

            Notes:
                Set of disk usage details.

                
        """
        self._disks = value

    
    @property
    def embedded_metadata(self):
        """ Get embedded_metadata value.

            Notes:
                Metadata objects associated with this entity. This will contain a list of Metadata objects if the API request is made using the special flag to enable the embedded Metadata feature. Only a maximum of Metadata objects is returned based on the value set in the system configuration.

                
                This attribute is named `embeddedMetadata` in VSD API.
                
        """
        return self._embedded_metadata

    @embedded_metadata.setter
    def embedded_metadata(self, value):
        """ Set embedded_metadata value.

            Notes:
                Metadata objects associated with this entity. This will contain a list of Metadata objects if the API request is made using the special flag to enable the embedded Metadata feature. Only a maximum of Metadata objects is returned based on the value set in the system configuration.

                
                This attribute is named `embeddedMetadata` in VSD API.
                
        """
        self._embedded_metadata = value

    
    @property
    def entity_scope(self):
        """ Get entity_scope value.

            Notes:
                Specify if scope of entity is Data center or Enterprise level

                
                This attribute is named `entityScope` in VSD API.
                
        """
        return self._entity_scope

    @entity_scope.setter
    def entity_scope(self, value):
        """ Set entity_scope value.

            Notes:
                Specify if scope of entity is Data center or Enterprise level

                
                This attribute is named `entityScope` in VSD API.
                
        """
        self._entity_scope = value

    
    @property
    def location(self):
        """ Get location value.

            Notes:
                Identifies the entity to be associated with a location.

                
        """
        return self._location

    @location.setter
    def location(self, value):
        """ Set location value.

            Notes:
                Identifies the entity to be associated with a location.

                
        """
        self._location = value

    
    @property
    def role(self):
        """ Get role value.

            Notes:
                Flag to indicate that VRS-G redundancy state (active/standby/standalone).  Only applicable for gateways.

                
        """
        return self._role

    @role.setter
    def role(self, value):
        """ Set role value.

            Notes:
                Flag to indicate that VRS-G redundancy state (active/standby/standalone).  Only applicable for gateways.

                
        """
        self._role = value

    
    @property
    def uptime(self):
        """ Get uptime value.

            Notes:
                How long the VRS was up.

                
        """
        return self._uptime

    @uptime.setter
    def uptime(self, value):
        """ Set uptime value.

            Notes:
                How long the VRS was up.

                
        """
        self._uptime = value

    
    @property
    def creation_date(self):
        """ Get creation_date value.

            Notes:
                Time stamp when this object was created.

                
                This attribute is named `creationDate` in VSD API.
                
        """
        return self._creation_date

    @creation_date.setter
    def creation_date(self, value):
        """ Set creation_date value.

            Notes:
                Time stamp when this object was created.

                
                This attribute is named `creationDate` in VSD API.
                
        """
        self._creation_date = value

    
    @property
    def primary_vsc_connection_lost(self):
        """ Get primary_vsc_connection_lost value.

            Notes:
                Flag indicates whether the connection with the primary is lost, which will help trigger alarms.

                
                This attribute is named `primaryVSCConnectionLost` in VSD API.
                
        """
        return self._primary_vsc_connection_lost

    @primary_vsc_connection_lost.setter
    def primary_vsc_connection_lost(self, value):
        """ Set primary_vsc_connection_lost value.

            Notes:
                Flag indicates whether the connection with the primary is lost, which will help trigger alarms.

                
                This attribute is named `primaryVSCConnectionLost` in VSD API.
                
        """
        self._primary_vsc_connection_lost = value

    
    @property
    def product_version(self):
        """ Get product_version value.

            Notes:
                Product version supported by this entity.

                
                This attribute is named `productVersion` in VSD API.
                
        """
        return self._product_version

    @product_version.setter
    def product_version(self, value):
        """ Set product_version value.

            Notes:
                Product version supported by this entity.

                
                This attribute is named `productVersion` in VSD API.
                
        """
        self._product_version = value

    
    @property
    def is_resilient(self):
        """ Get is_resilient value.

            Notes:
                Flag to indicate that the VRS is part of a redundant group.

                
                This attribute is named `isResilient` in VSD API.
                
        """
        return self._is_resilient

    @is_resilient.setter
    def is_resilient(self, value):
        """ Set is_resilient value.

            Notes:
                Flag to indicate that the VRS is part of a redundant group.

                
                This attribute is named `isResilient` in VSD API.
                
        """
        self._is_resilient = value

    
    @property
    def status(self):
        """ Get status value.

            Notes:
                Computed status of the entity.

                
        """
        return self._status

    @status.setter
    def status(self, value):
        """ Set status value.

            Notes:
                Computed status of the entity.

                
        """
        self._status = value

    
    @property
    def multi_nic_vport_enabled(self):
        """ Get multi_nic_vport_enabled value.

            Notes:
                VRS is in Multi-NIC VPORT Mode

                
                This attribute is named `multiNICVPortEnabled` in VSD API.
                
        """
        return self._multi_nic_vport_enabled

    @multi_nic_vport_enabled.setter
    def multi_nic_vport_enabled(self, value):
        """ Set multi_nic_vport_enabled value.

            Notes:
                VRS is in Multi-NIC VPORT Mode

                
                This attribute is named `multiNICVPortEnabled` in VSD API.
                
        """
        self._multi_nic_vport_enabled = value

    
    @property
    def number_of_bridge_interfaces(self):
        """ Get number_of_bridge_interfaces value.

            Notes:
                Number of bridge interfaces defined in this VRS.

                
                This attribute is named `numberOfBridgeInterfaces` in VSD API.
                
        """
        return self._number_of_bridge_interfaces

    @number_of_bridge_interfaces.setter
    def number_of_bridge_interfaces(self, value):
        """ Set number_of_bridge_interfaces value.

            Notes:
                Number of bridge interfaces defined in this VRS.

                
                This attribute is named `numberOfBridgeInterfaces` in VSD API.
                
        """
        self._number_of_bridge_interfaces = value

    
    @property
    def number_of_containers(self):
        """ Get number_of_containers value.

            Notes:
                Number of containers defined in this VRS.

                
                This attribute is named `numberOfContainers` in VSD API.
                
        """
        return self._number_of_containers

    @number_of_containers.setter
    def number_of_containers(self, value):
        """ Set number_of_containers value.

            Notes:
                Number of containers defined in this VRS.

                
                This attribute is named `numberOfContainers` in VSD API.
                
        """
        self._number_of_containers = value

    
    @property
    def number_of_host_interfaces(self):
        """ Get number_of_host_interfaces value.

            Notes:
                Number of host interfaces defined in this VRS.

                
                This attribute is named `numberOfHostInterfaces` in VSD API.
                
        """
        return self._number_of_host_interfaces

    @number_of_host_interfaces.setter
    def number_of_host_interfaces(self, value):
        """ Set number_of_host_interfaces value.

            Notes:
                Number of host interfaces defined in this VRS.

                
                This attribute is named `numberOfHostInterfaces` in VSD API.
                
        """
        self._number_of_host_interfaces = value

    
    @property
    def number_of_virtual_machines(self):
        """ Get number_of_virtual_machines value.

            Notes:
                Number of VMs defined in this VRS.

                
                This attribute is named `numberOfVirtualMachines` in VSD API.
                
        """
        return self._number_of_virtual_machines

    @number_of_virtual_machines.setter
    def number_of_virtual_machines(self, value):
        """ Set number_of_virtual_machines value.

            Notes:
                Number of VMs defined in this VRS.

                
                This attribute is named `numberOfVirtualMachines` in VSD API.
                
        """
        self._number_of_virtual_machines = value

    
    @property
    def current_cpuusage(self):
        """ Get current_cpuusage value.

            Notes:
                Current CPU usage percentage.

                
                This attribute is named `currentCPUUsage` in VSD API.
                
        """
        return self._current_cpuusage

    @current_cpuusage.setter
    def current_cpuusage(self, value):
        """ Set current_cpuusage value.

            Notes:
                Current CPU usage percentage.

                
                This attribute is named `currentCPUUsage` in VSD API.
                
        """
        self._current_cpuusage = value

    
    @property
    def current_memory_usage(self):
        """ Get current_memory_usage value.

            Notes:
                Current memory usage percentage.

                
                This attribute is named `currentMemoryUsage` in VSD API.
                
        """
        return self._current_memory_usage

    @current_memory_usage.setter
    def current_memory_usage(self, value):
        """ Set current_memory_usage value.

            Notes:
                Current memory usage percentage.

                
                This attribute is named `currentMemoryUsage` in VSD API.
                
        """
        self._current_memory_usage = value

    
    @property
    def average_cpuusage(self):
        """ Get average_cpuusage value.

            Notes:
                Average CPU usage percentage.

                
                This attribute is named `averageCPUUsage` in VSD API.
                
        """
        return self._average_cpuusage

    @average_cpuusage.setter
    def average_cpuusage(self, value):
        """ Set average_cpuusage value.

            Notes:
                Average CPU usage percentage.

                
                This attribute is named `averageCPUUsage` in VSD API.
                
        """
        self._average_cpuusage = value

    
    @property
    def average_memory_usage(self):
        """ Get average_memory_usage value.

            Notes:
                Average memory usage percentage.

                
                This attribute is named `averageMemoryUsage` in VSD API.
                
        """
        return self._average_memory_usage

    @average_memory_usage.setter
    def average_memory_usage(self, value):
        """ Set average_memory_usage value.

            Notes:
                Average memory usage percentage.

                
                This attribute is named `averageMemoryUsage` in VSD API.
                
        """
        self._average_memory_usage = value

    
    @property
    def owner(self):
        """ Get owner value.

            Notes:
                Identifies the user that has created this object.

                
        """
        return self._owner

    @owner.setter
    def owner(self, value):
        """ Set owner value.

            Notes:
                Identifies the user that has created this object.

                
        """
        self._owner = value

    
    @property
    def external_id(self):
        """ Get external_id value.

            Notes:
                External object ID. Used for integration with third party systems

                
                This attribute is named `externalID` in VSD API.
                
        """
        return self._external_id

    @external_id.setter
    def external_id(self, value):
        """ Set external_id value.

            Notes:
                External object ID. Used for integration with third party systems

                
                This attribute is named `externalID` in VSD API.
                
        """
        self._external_id = value

    
    @property
    def hypervisor_connection_state(self):
        """ Get hypervisor_connection_state value.

            Notes:
                The VRS connection state with the hypervisor.

                
                This attribute is named `hypervisorConnectionState` in VSD API.
                
        """
        return self._hypervisor_connection_state

    @hypervisor_connection_state.setter
    def hypervisor_connection_state(self, value):
        """ Set hypervisor_connection_state value.

            Notes:
                The VRS connection state with the hypervisor.

                
                This attribute is named `hypervisorConnectionState` in VSD API.
                
        """
        self._hypervisor_connection_state = value

    
    @property
    def hypervisor_identifier(self):
        """ Get hypervisor_identifier value.

            Notes:
                The hypervisor IP (or name) associated with the VRS.

                
                This attribute is named `hypervisorIdentifier` in VSD API.
                
        """
        return self._hypervisor_identifier

    @hypervisor_identifier.setter
    def hypervisor_identifier(self, value):
        """ Set hypervisor_identifier value.

            Notes:
                The hypervisor IP (or name) associated with the VRS.

                
                This attribute is named `hypervisorIdentifier` in VSD API.
                
        """
        self._hypervisor_identifier = value

    
    @property
    def hypervisor_name(self):
        """ Get hypervisor_name value.

            Notes:
                The hypervisor name associated with the VRS.

                
                This attribute is named `hypervisorName` in VSD API.
                
        """
        return self._hypervisor_name

    @hypervisor_name.setter
    def hypervisor_name(self, value):
        """ Set hypervisor_name value.

            Notes:
                The hypervisor name associated with the VRS.

                
                This attribute is named `hypervisorName` in VSD API.
                
        """
        self._hypervisor_name = value

    
    @property
    def hypervisor_type(self):
        """ Get hypervisor_type value.

            Notes:
                The hypervisor type associated with the VRS.

                
                This attribute is named `hypervisorType` in VSD API.
                
        """
        return self._hypervisor_type

    @hypervisor_type.setter
    def hypervisor_type(self, value):
        """ Set hypervisor_type value.

            Notes:
                The hypervisor type associated with the VRS.

                
                This attribute is named `hypervisorType` in VSD API.
                
        """
        self._hypervisor_type = value

    

    