# oxyba -- my wrapper functions and classes for python

The oxyba package contains my wrapper functions and classes.

There is no particular purpose nor structure within this package.
New wrapper functions and classes are just added to main package folder.

I advise against using any of this code in production.  
Just don't.
Feel free to copy code and adjust it to your own needs. 


### Installation

Check the source code at https://github.com/ulf1/oxyba

```sh
pip install oxyba
```

### Load the package

I am going to use the ox shortcut

```python
import oxyba as ox
```

### Examples
* see [oxyba.de/docs](http://oxyba.de/docs/)
* or download [Jupyter Notebooks](https://github.com/ulf1/oxyba-nbs/oxyba)

### Versioning

After v0.1.11 the versioning rules changed. 
A version X.Y.Z will have the following meaning.

- X: Major changes for the package
- Y: New function, class, module was added
- Z: Bugfixes, minor changes


### Notes to myself

1. Update setup.py (version, requirements)
2. Update CHANGES.txt (what's added, changed, removed?)
3. Run:  python setup.py sdist upload -r pypi


### Functions


#### Sampling, Resampling

* block_idxmat_sets
* block_idxmat_shuffle
* crossvalidation_loop
* crossvalidation_stats
* threeway_split
* jackknife_loop
* jackknife_stats


#### Data Cleaning with Pandas

* clean_add_strdec
* clean_dateobject_to_string
* clean_german_date
* clean_german_number
* clean_to_decimal

#### Data Cleaning (other)

* date_to_datetime
* drop_empty_records

#### Feature/Variable Checking

* features_check_singular
* isordinal

#### Correlations Matricies

* corr
* corr_rank
* corr_tau

DataViz

* heatmap_corr
* hist_corr_pval
* hist_corr_pval_groups

#### Correlation Matrix Adjustment

* illcond_corrmat
* subjcorr_luriegold
* subjcorr_kfactor
* subjcorr_onepara

#### Random Variables

Random Correlated Variables

* rand_bivar
* rand_chol
* rand_imancon

Random Dates

* rand_dates

#### Date Functions

* yearfrac_365q

#### Other stats

* nominal_count
* nominal_mode
* norm_mle


#### Linear Regression 

* linreg_ridge_lu
* linreg_mle
* linreg_ols_lu
* linreg_ols_pinv
* linreg_ols_qr
* linreg_ols_svd

linreg_ols_utils.py

* linreg_predict
* linreg_residuals
* linreg_ssr
* linreg_mse
* linreg_rmse


#### Financial Models

* leland94


#### Databases 

* mysql_batch_and_fetch


#### Python

* pip_upgrade
