# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['default_mutable']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'default-mutable',
    'version': '0.1.0',
    'description': 'Prevent mutable default arguments behavior',
    'long_description': 'Default Mutable\n==========\n\n### *Prevent mutable default value behavior*\n\nDefault Mutable is a Python decorator that overrides default mutable values and prevents object mutation from one call to another. More info on https://docs.python-guide.org/writing/gotchas/\n\n## Features\n\n- Easy to use\n- Preset default value\n\n## Advantages\n\n- Highly flexible\n- Lightweight and independent\n- Open-source\n- Real use cases\n- Support & documentation\n\n## Authors\n\n- Rudy Fernandez\n\n## Install\nThe easiest way to install default_mutable using pip:\n`pip install default_mutable`\n\n## [Examples](https://github.com/roodrepo/default_mutable/blob/v0-dev/examples/example1.py)\n\n\nPython’s default arguments are evaluated once when the function is defined, not each time the function is called (like it is in say, Ruby). This means that if you use a mutable default argument and mutate it, you will and have mutated that object for all future calls to the function as well.\n```python\ndef function1(idx, dict1 = {}, list1 = [], element = \'a\'):\n    list1.append(element)\n    dict1[f\'{element}{idx}\'] = f\'{element}{idx}\'\n    print(\'\', idx, dict1, list1)\n\nprint(\'\')\nprint(\'function1:\')\nfunction1(idx= 1)   # 1 {\'a1\': \'a1\'} [\'a\']\nfunction1(idx= 2)   # 2 {\'a1\': \'a1\', \'a2\': \'a2\'} [\'a\', \'a\']\n```\n\n---\n\nSetting all the arguments with mutable default arguments to an **EMPTY** dictionary or list\n```python\nfrom default_mutable.DefaultMutable import defaultMutable\n\n@defaultMutable\ndef function2(idx, dict1 = {}, list1 = [], element = \'a\'):\n    list1.append(element)\n    dict1[f\'{element}{idx}\'] = f\'{element}{idx}\'\n    print(\'\', idx, dict1, list1)\n\nprint(\'\')\nprint(\'function2:\')\nfunction2(1)    # 1 {\'a1\': \'a1\'} [\'a\']\nfunction2(2)    # 2 {\'a2\': \'a2\'} [\'a\']\n```\n\n---\n\nSetting all the arguments with mutable default arguments to an **EMPTY** dictionary or list\n```python\nfrom default_mutable.DefaultMutable import defaultMutable\n\n@defaultMutable\ndef function2_2(idx, dict1 = {}, list1 = [\'list_init\'], element = \'a\'):\n    list1.append(element)\n    dict1[f\'{element}{idx}\'] = f\'{element}{idx}\'\n    print(\'\', idx, dict1, list1)\n\nprint(\'\')\nprint(\'function2_2:\')\nfunction2_2(1)    # 1 {\'a1\': \'a1\'} [\'a\']\nfunction2_2(2)    # 2 {\'a2\': \'a2\'} [\'a\']\n```\n\n---\n\nWhen the decorator is executed with not arguments, we get the default behavior (same as "function1")\n```python\nfrom default_mutable.DefaultMutable import defaultMutable\n\n@defaultMutable()\ndef function3(idx, dict1 = {}, list1 = [], element = \'a\'):\n    list1.append(element)\n    dict1[f\'{element}{idx}\'] = f\'{element}{idx}\'\n    print(\'\', idx, dict1, list1)\n\nprint(\'\')\nprint(\'function3:\')\nfunction3(idx= 1)   # 1 {\'a1\': \'a1\'} [\'a\']\nfunction3(idx= 2)   # 2 {\'a1\': \'a1\', \'a2\': \'a2\'} [\'a\', \'a\']\n```\n\n---\n\nAs no value is passed, the decorator set the default value for "dict1" and "list1" an empty dictionary and empty list\n```python\nfrom default_mutable.DefaultMutable import defaultMutable\n\n@defaultMutable(\'dict1\', \'list1\')\ndef function4(idx, dict1 = {}, list1 = [], element = \'a\'):\n    list1.append(element)\n    dict1[f\'{element}{idx}\'] = f\'{element}{idx}\'\n    print(\'\', idx, dict1, list1)\n\nprint(\'\')\nprint(\'function4:\')\nfunction4(idx= 1)   # 1 {\'a1\': \'a1\'} [\'a\']\nfunction4(idx= 2)   # 2 {\'a2\': \'a2\'} [\'a\']\n```\n\n---\n\nAs no value is passed, the decorator set the default value for "dict1" and "list1" an empty dictionary and empty list\n```python\nfrom default_mutable.DefaultMutable import defaultMutable\n\n@defaultMutable(\'dict1\', \'list1\')\ndef function4_2(idx, dict1 = {}, list1 = [\'init\'], element = \'a\'):\n    list1.append(element)\n    dict1[f\'{element}{idx}\'] = f\'{element}{idx}\'\n    print(\'\', idx, dict1, list1)\n\nprint(\'\')\nprint(\'function4_2:\')\nfunction4_2(idx= 1)   # 1 {\'a1\': \'a1\'} [\'a\']\nfunction4_2(idx= 2)   # 2 {\'a2\': \'a2\'} [\'a\']\n```\n\n---\nAs no value is passed, the decorator set the default value for "list1" an empty list. "dict1" has the default behavior\n```python\nfrom default_mutable.DefaultMutable import defaultMutable\n\n@defaultMutable(\'list1\')\ndef function4_3(idx, dict1 = {}, list1 = [], element = \'a\'):\n    list1.append(element)\n    dict1[f\'{element}{idx}\'] = f\'{element}{idx}\'\n    print(\'\', idx, dict1, list1)\n\nprint(\'\')\nprint(\'function4_3:\')\nfunction4_3(idx= 1) # 1 {\'a1\': \'a1\'} [\'a\']\nfunction4_3(idx= 2) # 2 {\'a1\': \'a1\', \'a2\': \'a2\'} [\'a\']\n```\n\n---\nThe default values are mutable and "list1" get incremented from one function to the other\n```python\ndef function5(idx, dict1 = {}, list1 = [\'init\'], element = \'a\'):\n    list1.append(element)\n    dict1[f\'{element}{idx}\'] = f\'{element}{idx}\'\n    print(\'\', idx, dict1, list1)\n\nprint(\'\')\nprint(\'function5:\')\nfunction5(idx= 1)   # 1 {\'a1\': \'a1\'} [\'init\', \'a\']\nfunction5(idx= 2)   # 2 {\'a1\': \'a1\', \'a2\': \'a2\'} [\'init\', \'a\', \'a\']\n```\n\n---\nDefault value for "list1" is not an empty list\n```python\nfrom default_mutable.DefaultMutable import defaultMutable\n\n@defaultMutable(\'dict1\', list1= [\'init\'])\ndef function6(idx, dict1 = {}, list1 = [\'init\'], element = \'a\'):\n    list1.append(element)\n    dict1[f\'{element}{idx}\'] = f\'{element}{idx}\'\n    print(\'\', idx, dict1, list1)\n\nprint(\'\')\nprint(\'function6:\')\nfunction6(idx= 1)   # 1 {\'a1\': \'a1\'} [\'init\', \'a\']\nfunction6(idx= 2)   # 2 {\'a2\': \'a2\'} [\'init\', \'a\']\n```\n\n---\nDefault value for "list1" is not an empty list\n```python\nfrom default_mutable.DefaultMutable import defaultMutable\n\n@defaultMutable(\'dict1\', list1= [\'init\'])\ndef function7(idx, dict1 = {}, list1 = [], element = \'a\'):\n    list1.append(element)\n    dict1[f\'{element}{idx}\'] = f\'{element}{idx}\'\n    print(\'\', idx, dict1, list1)\n\nprint(\'\')\nprint(\'function7:\')\nfunction7(idx= 1)   # 1 {\'a1\': \'a1\'} [\'init\', \'a\']\nfunction7(idx= 2)   # 2 {\'a2\': \'a2\'} [\'init\', \'a\']\n```\n\n---\nDefault value are empty dictionary and empty list\n```python\nfrom default_mutable.DefaultMutable import defaultMutable\n\n@defaultMutable(\'dict1\', list1= [])\ndef function7_2(idx, dict1 = {}, list1 = [\'init\'], element = \'a\'):\n    list1.append(element)\n    dict1[f\'{element}{idx}\'] = f\'{element}{idx}\'\n    print(\'\', idx, dict1, list1)\n\nprint(\'\')\nprint(\'function7_2:\')\nfunction7_2(idx= 1) # 1 {\'a1\': \'a1\'} [\'a\']\nfunction7_2(idx= 2) # 2 {\'a2\': \'a2\'} [\'a\']\n```\n---\nDefault value are empty dictionary and empty list\n```python\nfrom default_mutable.DefaultMutable import defaultMutable\n\n@defaultMutable(\'dict1\', \'list1\')\ndef function7_3(idx, dict1 = {}, list1 = [\'init\'], element = \'a\'):\n    list1.append(element)\n    dict1[f\'{element}{idx}\'] = f\'{element}{idx}\'\n    print(\'\', idx, dict1, list1)\n\nprint(\'\')\nprint(\'function7_3:\')\nfunction7_3(idx= 1) # 1 {\'a1\': \'a1\'} [\'a\']\nfunction7_3(idx= 2) # 2 {\'a2\': \'a2\'} [\'a\']\n```\n\n---\nDefault value for "dict1" and "list1" are preset\n```python\nfrom default_mutable.DefaultMutable import defaultMutable\n\n@defaultMutable(dict1= {\'dict_init\': \'dict_init\'}, list1= [\'init\'])\ndef function8(idx, dict1 = {}, list1 = [], element = \'a\'):\n    list1.append(element)\n    dict1[f\'{element}{idx}\'] = f\'{element}{idx}\'\n    print(\'\', idx, dict1, list1)\n\nprint(\'\')\nprint(\'function8:\')\nfunction8(idx= 1)   # 1 {\'dict_init\': \'dict_init\', \'a1\': \'a1\'} [\'init\', \'a\']\nfunction8(idx= 2)   # 2 {\'dict_init\': \'dict_init\', \'a2\': \'a2\'} [\'init\', \'a\']\n```\n\n---\nPassed values are not overridden\n```python\nfrom default_mutable.DefaultMutable import defaultMutable\n\n@defaultMutable(dict1= {\'dict_init\': \'dict_init\'}, list1= [\'init\'])\ndef function9(idx, dict1 = {}, list1 = [], element = \'a\'):\n    list1.append(element)\n    dict1[f\'{element}{idx}\'] = f\'{element}{idx}\'\n    print(\'\', idx, dict1, list1)\n\nprint(\'\')\nprint(\'function9:\')\nfunction9(idx= 1, dict1= {\'dict_value\': \'dict_value\'}, list1= [\'list_value\'])   # 1 {\'dict_value\': \'dict_value\', \'a1\': \'a1\'} [\'list_value\', \'a\']\nfunction9(idx= 2, dict1= {\'dict_value\': \'dict_value\'}, list1= [\'list_value\'])   # 2 {\'dict_value\': \'dict_value\', \'a2\': \'a2\'} [\'list_value\', \'a\']\n\n```\n\n---\nPassed values are not overridden\n```python\nfrom default_mutable.DefaultMutable import defaultMutable\n\n@defaultMutable(dict1= {\'dict_init\': \'dict_init\'}, list1= [\'init\'])\ndef function10(idx, dict1 = {}, list1 = [], element = \'a\'):\n    list1.append(element)\n    dict1[f\'{element}{idx}\'] = f\'{element}{idx}\'\n    print(\'\', idx, dict1, list1)\n\nprint(\'\')\nprint(\'function10:\')\nfunction10(1, {\'dict_value\': \'dict_value\'}, [\'list_value\']) # 1 {\'dict_value\': \'dict_value\', \'a1\': \'a1\'} [\'list_value\', \'a\']\nfunction10(2, {\'dict_value\': \'dict_value\'}, [\'list_value\']) # 2 {\'dict_value\': \'dict_value\', \'a2\': \'a2\'} [\'list_value\', \'a\']\n```\n\n',
    'author': 'Rood Repo',
    'author_email': 'roodrepo@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/roodrepo/default_mutable',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3,<4',
}


setup(**setup_kwargs)
